/*
 * Decompiled with CFR 0.152.
 */
package yeoupooh.scraper;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import yeoupooh.scraper.DefaultLogger;
import yeoupooh.scraper.HtmlUtil;
import yeoupooh.scraper.ILogger;
import yeoupooh.scraper.SiteFile;

public class Scraper {
    private final String ENGINE_VERSION = "1.43";
    private final String SCRIPT_VERSION = "1.4";
    private final String TAIL_MESSAGE = "Powered by Scraper (E:v1.43, S:v1.4)";
    private ILogger m_logger = new DefaultLogger();

    public void setLogger(ILogger iLogger) {
        this.m_logger = iLogger;
    }

    public int handleLink(String string, String string2, String string3, int n, String string4, BufferedReader bufferedReader, String string5, PrintStream printStream) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        stringTokenizer.nextToken();
        String string6 = stringTokenizer.nextToken();
        String string7 = stringTokenizer.nextToken();
        int n2 = 0;
        if (stringTokenizer.hasMoreTokens()) {
            n2 = new Integer(stringTokenizer.nextToken());
        }
        while (string3 != null) {
            if (string3.toLowerCase().indexOf("<a") > -1) {
                String string8;
                int n3;
                int n4;
                if (n2 > 1) {
                    n4 = 1;
                    while (n4 < n2) {
                        n3 = string3.toLowerCase().indexOf("<a");
                        int n5 = string3.toLowerCase().indexOf("</a>");
                        string3 = string3.substring(n5 + 4);
                        ++n4;
                    }
                }
                this.m_logger.debug("before select=" + string3);
                n4 = string3.toLowerCase().indexOf("href") + 5;
                n3 = string3.toLowerCase().indexOf(">", string3.toLowerCase().indexOf("href") + 5);
                String string9 = HtmlUtil.removeStr(string3.substring(n4, n3).trim(), "\"");
                string9 = HtmlUtil.removeStr(string9, "'");
                if (string9.indexOf(" ") > -1) {
                    string9 = string9.substring(0, string9.indexOf(" "));
                }
                this.m_logger.debug("href=" + string9);
                String string10 = HtmlUtil.removeTagsAll(string3).trim();
                if (!string10.equals("")) {
                    printStream.println("<a href=" + string6 + ">" + string10 + "</a>");
                }
                if (string9.startsWith("/")) {
                    string8 = "http://" + new URL(string).getHost() + string9;
                } else if (string9.startsWith("http://")) {
                    string8 = string9;
                } else {
                    URL uRL = new URL(string);
                    String string11 = uRL.getPath();
                    int n6 = -1;
                    int n7 = -1;
                    if (string11.indexOf("/") > -1) {
                        n6 = string11.indexOf("/") + 1;
                        while ((n7 = string11.indexOf("/", n6)) != -1) {
                            n6 = n7 + 1;
                        }
                    }
                    string8 = "http://" + uRL.getHost() + string11.substring(0, n6) + string9;
                }
                this.readSite(string8, string4, string7, string5, string6);
            }
            if (string3.toLowerCase().indexOf("</a>") > -1) {
                this.m_logger.debug("=====break======");
                break;
            }
            string3 = bufferedReader.readLine();
            ++n;
        }
        return n;
    }

    public void handlePrint(String string, PrintStream printStream) {
        int n = string.indexOf(",");
        printStream.println(string.substring(n + 1));
    }

    public void handleTime(String string, PrintStream printStream) {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = null;
        int n = string.indexOf(",");
        simpleDateFormat = n > -1 ? new SimpleDateFormat(string.substring(n + 1)) : new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        printStream.println(simpleDateFormat.format(date));
    }

    public int handleText(String string, String string2, int n, BufferedReader bufferedReader, PrintStream printStream) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = null;
        boolean bl = false;
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        } else {
            string4 = string3;
            bl = true;
        }
        while (string2 != null) {
            if (string2.indexOf(string3) > -1 || bl) {
                String string5;
                if (!bl) {
                    string2 = string2.substring(string2.indexOf(string3));
                }
                if (!(string5 = HtmlUtil.removeTags(string2)).equals("")) {
                    printStream.println(string5);
                }
                bl = true;
            }
            if (string2.indexOf(string4) > -1) break;
            string2 = bufferedReader.readLine();
            ++n;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int handleSkip(String string, String string2, int n, BufferedReader bufferedReader) throws IOException, NullPointerException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        this.m_logger.debug("handleSkip: initial line=" + string2);
        this.m_logger.debug("handleSkip: reader=" + bufferedReader);
        if (string3.equals("curr")) {
            int n2 = new Integer(stringTokenizer.nextToken());
            int n3 = 0;
            while (n3 < n2) {
                string2 = bufferedReader.readLine();
                ++n;
                ++n3;
            }
            return n;
        } else if (string3.equals("start")) {
            int n4 = new Integer(stringTokenizer.nextToken());
            while (n < n4) {
                string2 = bufferedReader.readLine();
                ++n;
            }
            return n;
        } else if (string3.equals("until")) {
            String string4 = stringTokenizer.nextToken();
            this.m_logger.debug("until str=" + string4);
            do {
                this.m_logger.debug("until line=[" + string2 + "]");
                if (string2.indexOf(string4) > -1) return n;
                string2 = bufferedReader.readLine();
                this.m_logger.debug("until line=[" + string2 + "]");
                this.m_logger.debug("count=[" + n + "]");
                ++n;
            } while (string2 != null);
            this.m_logger.error("cannot found until string[" + string4 + "]");
            return n;
        } else {
            this.m_logger.error("unknown command: " + string3);
        }
        return n;
    }

    public void handleRun(String string, int n, String string2, BufferedReader bufferedReader, String string3, PrintStream printStream) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string5 = stringTokenizer.nextToken();
        }
        SiteFile siteFile = new SiteFile();
        siteFile.loadFromFile(string2 + "/" + string4);
        if (string5 != null) {
            printStream.println("<a href=" + siteFile.getOutputFilename() + ">" + string5 + "</a>");
        } else {
            printStream.println("<a href=" + siteFile.getOutputFilename() + ">" + siteFile.getDescription() + "</a>");
        }
        this.startScrapping(string2, string4, string3);
    }

    public void readSite(String string, String string2, String string3, String string4, String string5) throws IOException {
        this.m_logger.debug("========< START >==========================");
        this.m_logger.info("read url=[" + string + "]");
        this.m_logger.info("read file=[" + string3 + "]");
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(new File(string4 + "/" + string5)));
        }
        catch (IOException iOException) {
            this.m_logger.error("can't open output file[" + string4 + "/" + string5 + "]");
            iOException.printStackTrace();
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(string2 + "/" + string3))));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        InputStream inputStream = null;
        BufferedReader bufferedReader2 = null;
        String string6 = null;
        String string7 = null;
        try {
            inputStream = uRL.openStream();
            bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream));
            string6 = bufferedReader.readLine();
            this.m_logger.info("version=" + string6);
            string6 = bufferedReader.readLine();
            this.m_logger.info("site title=" + string6);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_logger.error("url not found. url=[" + uRL + "]");
            fileNotFoundException.printStackTrace();
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        try {
            string6 = bufferedReader.readLine();
            string7 = bufferedReader2.readLine();
            this.m_logger.debug("readSite: first line=" + string7);
            if (string7 == null) {
                this.m_logger.debug("readSite: first line is NULL");
            } else if (string7.equals("")) {
                this.m_logger.debug("readSite: first line is empty");
            }
            int n = 1;
            while (string6 != null) {
                this.m_logger.debug("script=" + string6);
                this.m_logger.debug("count=" + n);
                if (string6.startsWith("skip")) {
                    try {
                        n = this.handleSkip(string6, string7, n, bufferedReader2);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else if (string6.startsWith("link")) {
                    try {
                        n = this.handleLink(string, string6, string7, n, string2, bufferedReader2, string4, printStream);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else if (string6.startsWith("text")) {
                    try {
                        n = this.handleText(string6, string7, n, bufferedReader2, printStream);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else if (string6.startsWith("print")) {
                    this.handlePrint(string6, printStream);
                } else if (string6.startsWith("run")) {
                    try {
                        this.handleRun(string6, n, string2, bufferedReader2, string4, printStream);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else if (string6.startsWith("time")) {
                    this.handleTime(string6, printStream);
                } else if (!string6.trim().equals("") && !string6.startsWith("#")) {
                    System.err.println("unknown command: " + string6);
                }
                try {
                    string6 = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            printStream.println("<p>Powered by Scraper (E:v1.43, S:v1.4)</p>");
            if (bufferedReader2 != null) {
                bufferedReader2.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (NullPointerException nullPointerException) {
            this.m_logger.error("NullPointerException");
            nullPointerException.printStackTrace();
        }
        catch (IOException iOException) {
            this.m_logger.error("can't read.");
            iOException.printStackTrace();
        }
        printStream.close();
        this.m_logger.debug("------------< END >------------");
    }

    public void startScrapping(String string, String string2, String string3) throws IOException {
        this.m_logger.info("start scrapping...");
        SiteFile siteFile = new SiteFile();
        siteFile.loadFromFile(string + "/" + string2);
        this.m_logger.debug("Version=" + siteFile.getVersion());
        this.m_logger.debug("Site Description=" + siteFile.getDescription());
        this.readSite(siteFile.getUrl(), string, siteFile.getScriptFilename(), string3, siteFile.getOutputFilename());
        this.m_logger.info("scrapping finished.");
    }

    public String getEngineVersion() {
        return "1.43";
    }

    public String getScriptVersion() {
        return "1.4";
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 3) {
            Scraper scraper = new Scraper();
            try {
                scraper.startScrapping(stringArray[0], stringArray[1], stringArray[2]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

