/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.CHOOSECOLOR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;

    public ColorDialog(Shell parent) {
        this(parent, 0);
    }

    public ColorDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    int CCHookProc(int hdlg, int uiMsg, int lParam, int lpData) {
        switch (uiMsg) {
            case 272: {
                if (this.title == null || this.title.length() == 0) break;
                TCHAR buffer = new TCHAR(0, this.title, true);
                OS.SetWindowText(hdlg, buffer);
            }
        }
        return 0;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        int blue;
        int green;
        int red;
        int hwndOwner = this.parent.handle;
        Callback callback = new Callback(this, "CCHookProc", 4);
        int lpfnHook = callback.getAddress();
        Display display = this.parent.getDisplay();
        if (display.lpCustColors == 0) {
            int hHeap = OS.GetProcessHeap();
            display.lpCustColors = OS.HeapAlloc(hHeap, 8, 64);
        }
        CHOOSECOLOR lpcc = new CHOOSECOLOR();
        lpcc.lStructSize = 36;
        lpcc.Flags = 272;
        lpcc.lpfnHook = lpfnHook;
        lpcc.hwndOwner = hwndOwner;
        lpcc.lpCustColors = display.lpCustColors;
        if (this.rgb != null) {
            lpcc.Flags |= 1;
            red = this.rgb.red & 0xFF;
            green = this.rgb.green << 8 & 0xFF00;
            blue = this.rgb.blue << 16 & 0xFF0000;
            lpcc.rgbResult = red | green | blue;
        }
        this.rgb = null;
        if (OS.ChooseColor(lpcc)) {
            red = lpcc.rgbResult & 0xFF;
            green = lpcc.rgbResult >> 8 & 0xFF;
            blue = lpcc.rgbResult >> 16 & 0xFF;
            this.rgb = new RGB(red, green, blue);
        }
        callback.dispose();
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

