/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class RTFTransfer
extends ByteArrayTransfer {
    private static final String CF_RTF_NAME = "Rich Text Format";
    private static final int CF_RTF = Transfer.registerType("Rich Text Format");
    private static RTFTransfer _instance = new RTFTransfer();
    private static int CodePage = OS.GetACP();

    private RTFTransfer() {
    }

    public static RTFTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof String)) {
            transferData.result = -2147467259;
            return;
        }
        if (this.isSupportedType(transferData)) {
            String string = (String)object;
            int count = string.length();
            char[] buffer = new char[count + 1];
            string.getChars(0, count, buffer, 0);
            int cchMultiByte = OS.WideCharToMultiByte(CodePage, 0, buffer, -1, null, 0, null, null);
            if (cchMultiByte == 0) {
                transferData.stgmedium = new STGMEDIUM();
                transferData.result = -2147221402;
                return;
            }
            int lpMultiByteStr = OS.GlobalAlloc(64, cchMultiByte);
            OS.WideCharToMultiByte(CodePage, 0, buffer, -1, lpMultiByteStr, cchMultiByte, null, null);
            transferData.stgmedium = new STGMEDIUM();
            transferData.stgmedium.tymed = 1;
            transferData.stgmedium.unionField = lpMultiByteStr;
            transferData.stgmedium.pUnkForRelease = 0;
            transferData.result = 0;
            return;
        }
        transferData.stgmedium = new STGMEDIUM();
        transferData.result = -2147221399;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        int lpMultiByteStr;
        block4: {
            String string;
            if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0) {
                transferData.result = -2147467259;
                return null;
            }
            IDataObject data = new IDataObject(transferData.pIDataObject);
            data.AddRef();
            STGMEDIUM stgmedium = new STGMEDIUM();
            FORMATETC formatetc = transferData.formatetc;
            stgmedium.tymed = 1;
            transferData.result = data.GetData(formatetc, stgmedium);
            data.Release();
            if (transferData.result != 0) {
                return null;
            }
            lpMultiByteStr = OS.GlobalLock(stgmedium.unionField);
            if (lpMultiByteStr == 0) return null;
            try {
                int cchWideChar = OS.MultiByteToWideChar(CodePage, 1, lpMultiByteStr, -1, null, 0);
                if (cchWideChar == 0) break block4;
                char[] lpWideCharStr = new char[cchWideChar];
                OS.MultiByteToWideChar(CodePage, 1, lpMultiByteStr, -1, lpWideCharStr, cchWideChar);
                string = new String(lpWideCharStr);
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                OS.GlobalUnlock(lpMultiByteStr);
                throw throwable;
            }
            OS.GlobalUnlock(lpMultiByteStr);
            return string;
        }
        Object var8_11 = null;
        OS.GlobalUnlock(lpMultiByteStr);
        return null;
    }

    protected int[] getTypeIds() {
        return new int[]{CF_RTF};
    }

    protected String[] getTypeNames() {
        return new String[]{"CF_RTF"};
    }
}

