/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.DefaultContent;
import org.eclipse.swt.custom.DefaultLineStyler;
import org.eclipse.swt.custom.DisplayRenderer;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.PrintRenderer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledTextBidi;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextListener;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.custom.WrappedContent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class StyledText
extends Canvas {
    static final char TAB = '\t';
    static final String PlatformLineDelimiter = System.getProperty("line.separator");
    static final int BIDI_CARET_WIDTH = 4;
    static final int XINSET = 3;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int ExtendedModify = 3000;
    static final int LineGetBackground = 3001;
    static final int LineGetStyle = 3002;
    static final int TextChanging = 3003;
    static final int TextSet = 3004;
    static final int VerifyKey = 3005;
    static final int TextChanged = 3006;
    static final int LineGetSegments = 3007;
    StyledTextContent logicalContent;
    StyledTextContent content;
    DisplayRenderer renderer;
    TextChangeListener textChangeListener;
    DefaultLineStyler defaultLineStyler;
    LineCache lineCache;
    boolean userLineStyle = false;
    boolean userLineBackground = false;
    int verticalScrollOffset = 0;
    int horizontalScrollOffset = 0;
    int topIndex = 0;
    int clientAreaHeight = 0;
    int clientAreaWidth = 0;
    int lineHeight;
    int tabLength = 4;
    int lineEndSpaceWidth;
    int leftMargin = 1;
    int topMargin = 1;
    int rightMargin = 2;
    int bottomMargin = 2;
    Cursor ibeamCursor;
    int caretOffset = 0;
    int caretLine = 0;
    Point selection = new Point(0, 0);
    int selectionAnchor;
    boolean editable = true;
    boolean wordWrap = false;
    boolean doubleClickEnabled = true;
    boolean overwrite = false;
    int textLimit = -1;
    Hashtable keyActionMap = new Hashtable();
    Color background = null;
    Color foreground = null;
    Clipboard clipboard;
    boolean mouseDoubleClick = false;
    int autoScrollDirection = 0;
    int lastTextChangeStart;
    int lastTextChangeNewLineCount;
    int lastTextChangeNewCharCount;
    int lastTextChangeReplaceLineCount;
    int lastTextChangeReplaceCharCount;
    boolean isBidi;
    boolean bidiColoring = false;
    Image leftCaretBitmap = null;
    Image rightCaretBitmap = null;
    int caretDirection = 0;
    PaletteData caretPalette = null;
    int lastCaretDirection = 0;

    public StyledText(Composite parent, int style) {
        super(parent, StyledText.checkStyle(style | 0x100000 | 0x40000));
        Display display = this.getDisplay();
        this.isBidi = StyledTextBidi.isBidiPlatform();
        if ((style & 8) != 0) {
            this.setEditable(false);
        }
        if ((style & 0x800) == 0 || (style & 4) == 0) {
            this.bottomMargin = 0;
            this.rightMargin = 0;
            this.topMargin = 0;
            this.leftMargin = 0;
        }
        this.clipboard = new Clipboard(display);
        this.installDefaultContent();
        this.initializeRenderer();
        if ((style & 0x40) != 0) {
            this.setWordWrap(true);
        } else {
            this.lineCache = new ContentWidthCache(this, this.content.getLineCount());
        }
        if (!this.isBidi()) {
            Caret caret = new Caret(this, 0);
            caret.setSize(1, caret.getSize().y);
        } else {
            this.createCaretBitmaps();
            this.createBidiCaret();
            Runnable runnable = new Runnable(){

                public void run() {
                    StyledText.this.setBidiCaretLocation(null);
                }
            };
            StyledTextBidi.addLanguageListener(this, runnable);
        }
        this.calculateScrollBars();
        this.createKeyBindings();
        this.ibeamCursor = new Cursor(display, 19);
        this.setCursor(this.ibeamCursor);
        this.installListeners();
        this.installDefaultLineStyler();
    }

    public void addExtendedModifyListener(ExtendedModifyListener extendedModifyListener) {
        this.checkWidget();
        if (extendedModifyListener == null) {
            SWT.error(4);
        }
        StyledTextListener typedListener = new StyledTextListener(extendedModifyListener);
        this.addListener(3000, typedListener);
    }

    public void setKeyBinding(int key, int action) {
        this.checkWidget();
        if (action == 0) {
            this.keyActionMap.remove(new Integer(key));
        } else {
            this.keyActionMap.put(new Integer(key), new Integer(action));
        }
    }

    public void addBidiSegmentListener(BidiSegmentListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        StyledTextListener typedListener = new StyledTextListener(listener);
        this.addListener(3007, typedListener);
    }

    public void addLineBackgroundListener(LineBackgroundListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (!this.userLineBackground) {
            this.removeLineBackgroundListener(this.defaultLineStyler);
            this.defaultLineStyler.setLineBackground(0, this.logicalContent.getLineCount(), null);
            this.userLineBackground = true;
        }
        StyledTextListener typedListener = new StyledTextListener(listener);
        this.addListener(3001, typedListener);
    }

    public void addLineStyleListener(LineStyleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (!this.userLineStyle) {
            this.removeLineStyleListener(this.defaultLineStyler);
            this.defaultLineStyler.setStyleRange(null);
            this.userLineStyle = true;
        }
        StyledTextListener typedListener = new StyledTextListener(listener);
        this.addListener(3002, typedListener);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
    }

    public void addVerifyKeyListener(VerifyKeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        StyledTextListener typedListener = new StyledTextListener(listener);
        this.addListener(3005, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int lastChar = Math.max(this.getCharCount(), 0);
        this.replaceTextRange(lastChar, 0, string);
    }

    void calculateContentWidth() {
        if (this.lineHeight != 0) {
            this.lineCache = this.getLineCache(this.content);
            this.lineCache.calculate(this.topIndex, this.getPartialBottomIndex() - this.topIndex + 1);
        }
    }

    void calculateScrollBars() {
        ScrollBar horizontalBar = this.getHorizontalBar();
        ScrollBar verticalBar = this.getVerticalBar();
        this.setScrollBars();
        if (verticalBar != null) {
            verticalBar.setIncrement(this.getVerticalIncrement());
        }
        if (horizontalBar != null) {
            horizontalBar.setIncrement(this.getHorizontalIncrement());
        }
    }

    static int checkStyle(int style) {
        if ((style & 4) != 0) {
            style &= 0xFFFFFCFF;
        }
        return style;
    }

    void claimBottomFreeSpace() {
        int newVerticalOffset = Math.max(0, this.content.getLineCount() * this.lineHeight - this.getClientArea().height);
        if (newVerticalOffset < this.verticalScrollOffset) {
            this.setVerticalScrollOffset(newVerticalOffset, true);
        }
    }

    void claimRightFreeSpace() {
        int newHorizontalOffset = Math.max(0, this.lineCache.getWidth() - (this.getClientArea().width - this.leftMargin - this.rightMargin));
        if (newHorizontalOffset < this.horizontalScrollOffset) {
            this.scrollHorizontalBar(newHorizontalOffset - this.horizontalScrollOffset);
        }
    }

    void clearMargin(GC gc, Color background, Rectangle clientArea, int renderHeight) {
        gc.setBackground(background);
        gc.fillRectangle(0, 0, clientArea.width, this.topMargin);
        gc.fillRectangle(0, 0, this.leftMargin, renderHeight);
        gc.fillRectangle(0, clientArea.height - this.bottomMargin, clientArea.width, this.bottomMargin);
        gc.fillRectangle(clientArea.width - this.rightMargin, 0, this.rightMargin, renderHeight);
    }

    void clearSelection(boolean sendEvent) {
        int selectionStart = this.selection.x;
        int selectionEnd = this.selection.y;
        int length = this.content.getCharCount();
        this.resetSelection();
        if (selectionEnd - selectionStart > 0) {
            int redrawStart = Math.min(selectionStart, length);
            int redrawEnd = Math.min(selectionEnd, length);
            if (redrawEnd - redrawStart > 0) {
                this.internalRedrawRange(redrawStart, redrawEnd - redrawStart, true);
            }
            if (sendEvent) {
                this.sendSelectionEvent();
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width;
        this.checkWidget();
        boolean singleLine = (this.getStyle() & 4) != 0;
        int count = singleLine ? 1 : this.content.getLineCount();
        if (this.wordWrap) {
            if (((WrappedContent)this.content).getVisualLineCount() != 0) {
                width = this.lineCache.getWidth();
                if (!singleLine) {
                    count = this.content.getLineCount();
                }
            } else {
                width = wHint != -1 ? wHint : 64;
                if (!singleLine) {
                    ((WrappedContent)this.content).wrapLines(width);
                    count = this.content.getLineCount();
                }
            }
        } else if (wHint != -1) {
            width = wHint;
        } else {
            int visibleCount = Math.min(count, this.getDisplay().getBounds().height / this.lineHeight);
            this.lineCache.calculate(0, visibleCount);
            width = this.lineCache.getWidth() + this.leftMargin + this.rightMargin;
        }
        int height = hHint != -1 ? hHint : count * this.lineHeight + this.topMargin + this.bottomMargin;
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = singleLine ? this.lineHeight : 64;
        }
        Rectangle rect = this.computeTrim(0, 0, width, height);
        return new Point(rect.width, rect.height);
    }

    public void copy() {
        block3: {
            this.checkWidget();
            int length = this.selection.y - this.selection.x;
            if (length > 0) {
                RTFTransfer rtfTransfer = RTFTransfer.getInstance();
                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                RTFWriter rtfWriter = new RTFWriter(this.selection.x, length);
                TextWriter plainTextWriter = new TextWriter(this.selection.x, length);
                String rtfText = this.getPlatformDelimitedText(rtfWriter);
                String plainText = this.getPlatformDelimitedText(plainTextWriter);
                try {
                    this.clipboard.setContents(new String[]{rtfText, plainText}, new Transfer[]{rtfTransfer, plainTextTransfer});
                }
                catch (SWTError error) {
                    if (error.code == 2002) break block3;
                    throw error;
                }
            }
        }
    }

    String getModelDelimitedText(String text) {
        String delimiter = this.getLineDelimiter();
        int length = text.length();
        int crIndex = 0;
        int lfIndex = 0;
        int i = 0;
        if (length == 0) {
            return text;
        }
        StringBuffer convertedText = new StringBuffer(length);
        while (i < length) {
            if (crIndex != -1) {
                crIndex = text.indexOf(13, i);
            }
            if (lfIndex != -1) {
                lfIndex = text.indexOf(10, i);
            }
            if (lfIndex == -1 && crIndex == -1) break;
            if (crIndex < lfIndex && crIndex != -1 || lfIndex == -1) {
                convertedText.append(text.substring(i, crIndex));
                i = lfIndex == crIndex + 1 ? lfIndex + 1 : crIndex + 1;
            } else {
                convertedText.append(text.substring(i, lfIndex));
                i = lfIndex + 1;
            }
            if (this.isSingleLine()) break;
            convertedText.append(delimiter);
        }
        if (!(i >= length || this.isSingleLine() && convertedText.length() != 0)) {
            convertedText.append(text.substring(i));
        }
        return convertedText.toString();
    }

    void createKeyBindings() {
        this.setKeyBinding(0x1000001, 0x1000001);
        this.setKeyBinding(0x1000002, 0x1000002);
        this.setKeyBinding(0x1000007, 0x1000007);
        this.setKeyBinding(0x1000008, 0x1000008);
        this.setKeyBinding(0x1000003, 0x1000003);
        this.setKeyBinding(0x1000004, 0x1000004);
        this.setKeyBinding(0x1000005, 0x1000005);
        this.setKeyBinding(0x1000006, 0x1000006);
        this.setKeyBinding(17039363, 17039363);
        this.setKeyBinding(0x1040004, 0x1040004);
        this.setKeyBinding(17039367, 17039367);
        this.setKeyBinding(17039368, 17039368);
        this.setKeyBinding(17039365, 17039365);
        this.setKeyBinding(17039366, 17039366);
        this.setKeyBinding(0x1020001, 0x1020001);
        this.setKeyBinding(0x1020002, 0x1020002);
        this.setKeyBinding(16908295, 16908295);
        this.setKeyBinding(16908296, 16908296);
        this.setKeyBinding(16908291, 16908291);
        this.setKeyBinding(16908292, 16908292);
        this.setKeyBinding(16908293, 16908293);
        this.setKeyBinding(16908294, 16908294);
        this.setKeyBinding(17170435, 17170435);
        this.setKeyBinding(17170436, 17170436);
        this.setKeyBinding(17170439, 17170439);
        this.setKeyBinding(17170440, 17170440);
        this.setKeyBinding(17170437, 17170437);
        this.setKeyBinding(0x1060006, 0x1060006);
        this.setKeyBinding(262168, 131199);
        this.setKeyBinding(262147, 17039369);
        this.setKeyBinding(262166, 16908297);
        this.setKeyBinding(131199, 131199);
        this.setKeyBinding(17039369, 17039369);
        this.setKeyBinding(16908297, 16908297);
        this.setKeyBinding(131080, 8);
        this.setKeyBinding(8, 8);
        this.setKeyBinding(127, 127);
        this.setKeyBinding(0x1000009, 0x1000009);
    }

    void createBidiCaret() {
        int direction;
        Caret caret = this.getCaret();
        if (caret == null) {
            caret = new Caret(this, 0);
        }
        if ((direction = StyledTextBidi.getKeyboardLanguageDirection()) == this.caretDirection) {
            return;
        }
        this.caretDirection = direction;
        if (this.caretDirection == 16384) {
            caret.setImage(this.leftCaretBitmap);
        } else if (this.caretDirection == 131072) {
            caret.setImage(this.rightCaretBitmap);
        }
    }

    void createCaretBitmaps() {
        int caretWidth = 4;
        Display display = this.getDisplay();
        if (this.caretPalette == null) {
            this.caretPalette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
        }
        if (this.leftCaretBitmap != null) {
            this.leftCaretBitmap.dispose();
        }
        ImageData imageData = new ImageData(caretWidth, this.lineHeight, 1, this.caretPalette);
        this.leftCaretBitmap = new Image((Device)display, imageData);
        GC gc = new GC(this.leftCaretBitmap);
        gc.setForeground(display.getSystemColor(1));
        gc.drawLine(0, 0, 0, this.lineHeight);
        gc.drawLine(0, 0, caretWidth - 1, 0);
        gc.drawLine(0, 1, 1, 1);
        gc.dispose();
        if (this.rightCaretBitmap != null) {
            this.rightCaretBitmap.dispose();
        }
        this.rightCaretBitmap = new Image((Device)display, imageData);
        gc = new GC(this.rightCaretBitmap);
        gc.setForeground(display.getSystemColor(1));
        gc.drawLine(caretWidth - 1, 0, caretWidth - 1, this.lineHeight);
        gc.drawLine(0, 0, caretWidth - 1, 0);
        gc.drawLine(caretWidth - 1, 1, 1, 1);
        gc.dispose();
    }

    public void cut() {
        this.checkWidget();
        if (this.selection.y > this.selection.x) {
            this.copy();
            this.doDelete();
        }
    }

    void doAutoScroll(Event event) {
        Rectangle area = this.getClientArea();
        if (event.y > area.height) {
            this.doAutoScroll(1024);
        } else if (event.y < 0) {
            this.doAutoScroll(128);
        } else if (event.x < this.leftMargin && !this.wordWrap) {
            this.doAutoScroll(16384);
        } else if (event.x > area.width - this.leftMargin - this.rightMargin && !this.wordWrap) {
            this.doAutoScroll(131072);
        } else {
            this.endAutoScroll();
        }
    }

    void doAutoScroll(int direction) {
        Runnable timer = null;
        if (this.autoScrollDirection == direction) {
            return;
        }
        final Display display = this.getDisplay();
        if (direction == 128) {
            timer = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 128) {
                        StyledText.this.doLineUp();
                        StyledText.this.doSelection(16384);
                        display.timerExec(5, this);
                    }
                }
            };
        } else if (direction == 1024) {
            timer = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 1024) {
                        StyledText.this.doLineDown();
                        StyledText.this.doSelection(131072);
                        display.timerExec(5, this);
                    }
                }
            };
        } else if (direction == 131072) {
            timer = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 131072) {
                        StyledText.this.doColumnRight();
                        StyledText.this.doSelection(131072);
                        display.timerExec(5, this);
                    }
                }
            };
        } else if (direction == 16384) {
            timer = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 16384) {
                        StyledText.this.doColumnLeft();
                        StyledText.this.doSelection(16384);
                        display.timerExec(5, this);
                    }
                }
            };
        }
        if (timer != null) {
            this.autoScrollDirection = direction;
            display.timerExec(5, timer);
        }
    }

    void doBackspace() {
        Event event = new Event();
        event.text = "";
        if (this.selection.x != this.selection.y) {
            event.start = this.selection.x;
            event.end = this.selection.y;
            this.sendKeyEvent(event);
        } else if (this.caretOffset > 0) {
            int line = this.content.getLineAtOffset(this.caretOffset);
            int lineOffset = this.content.getOffsetAtLine(line);
            if (this.caretOffset == lineOffset) {
                lineOffset = this.content.getOffsetAtLine(line - 1);
                event.start = lineOffset + this.content.getLine(line - 1).length();
                event.end = this.caretOffset;
            } else {
                event.start = this.caretOffset - 1;
                event.end = this.caretOffset;
            }
            this.sendKeyEvent(event);
        }
    }

    void doBidiMouseLocationChange(int x, int y, boolean select) {
        int line = (y + this.verticalScrollOffset) / this.lineHeight;
        int lineCount = this.content.getLineCount();
        if (line > lineCount - 1) {
            line = lineCount - 1;
        }
        if (line == 0 || !this.isSingleLine() && line > 0) {
            int newCaretOffset = this.getBidiOffsetAtMouseLocation(x, line);
            if (x >= 0 || this.content.getLineAtOffset(newCaretOffset) != this.content.getLineAtOffset(this.caretOffset)) {
                this.caretOffset = newCaretOffset;
                this.caretLine = line;
                if (select) {
                    this.doMouseSelection();
                }
                this.setBidiCaretLocation(null);
                this.setBidiKeyboardLanguage();
            }
            if (!select) {
                this.clearSelection(true);
            }
        }
    }

    void doColumnLeft() {
        int line = this.content.getLineAtOffset(this.caretOffset);
        int lineOffset = this.content.getOffsetAtLine(line);
        int offsetInLine = this.caretOffset - lineOffset;
        if (this.isBidi()) {
            String lineText = this.content.getLine(line);
            int lineLength = lineText.length();
            GC gc = new GC(this);
            StyledTextBidi bidi = this.getStyledTextBidi(lineText, lineOffset, gc);
            if (this.horizontalScrollOffset > 0 || offsetInLine > 0) {
                if (offsetInLine < lineLength && bidi.isRightToLeft(offsetInLine)) {
                    ++this.caretOffset;
                    this.doSelection(131072);
                    if (this.caretOffset - lineOffset == lineLength) {
                        this.showCaret();
                    }
                    if (!bidi.isRightToLeft(this.caretOffset - lineOffset)) {
                        if (bidi.getCaretPosition(this.caretOffset - lineOffset) < this.horizontalScrollOffset) {
                            this.showCaret();
                        }
                        --this.caretOffset;
                        while (this.caretOffset - lineOffset > 0 && bidi.isRightToLeft(this.caretOffset - lineOffset)) {
                            --this.caretOffset;
                        }
                    }
                } else if (offsetInLine == lineLength && bidi.getCaretPosition(lineLength) != 3) {
                    --this.caretOffset;
                    while (this.caretOffset - lineOffset > 0 && bidi.isRightToLeft(this.caretOffset - lineOffset)) {
                        --this.caretOffset;
                    }
                } else if (offsetInLine > 0 && !bidi.isRightToLeft(offsetInLine)) {
                    --this.caretOffset;
                    this.doSelection(16384);
                    if (this.caretOffset - lineOffset > 0 && bidi.isRightToLeft(this.caretOffset - lineOffset - 1)) {
                        --this.caretOffset;
                        while (this.caretOffset - lineOffset > 0 && bidi.isRightToLeft(this.caretOffset - lineOffset - 1)) {
                            --this.caretOffset;
                        }
                    }
                }
                if (bidi.getCaretPosition(this.caretOffset - lineOffset) < this.horizontalScrollOffset) {
                    this.showCaret();
                } else {
                    this.setCaretLocation();
                    this.setBidiKeyboardLanguage();
                }
                if (this.caretOffset - lineOffset == 0 && this.horizontalScrollOffset > 0 && this.horizontalScrollOffset <= 3) {
                    this.scrollHorizontalBar(-this.horizontalScrollOffset);
                }
            }
            gc.dispose();
        } else if (offsetInLine > 0) {
            --this.caretOffset;
            this.showCaret();
        }
    }

    void doColumnRight() {
        int line = this.content.getLineAtOffset(this.caretOffset);
        int lineOffset = this.content.getOffsetAtLine(line);
        int offsetInLine = this.caretOffset - lineOffset;
        String lineText = this.content.getLine(line);
        int lineLength = lineText.length();
        if (this.isBidi()) {
            GC gc = new GC(this);
            StyledTextBidi bidi = this.getStyledTextBidi(lineText, lineOffset, gc);
            if (bidi.getTextWidth() + this.leftMargin > this.horizontalScrollOffset + this.getClientArea().width || offsetInLine < lineLength) {
                if (!bidi.isRightToLeft(offsetInLine) && offsetInLine < lineLength) {
                    ++this.caretOffset;
                    this.doSelection(131072);
                    if (bidi.isRightToLeft(this.caretOffset - lineOffset)) {
                        ++this.caretOffset;
                        while (this.caretOffset < lineOffset + lineLength && bidi.isRightToLeft(this.caretOffset - lineOffset)) {
                            ++this.caretOffset;
                        }
                    }
                } else if (offsetInLine > 0 && (bidi.isRightToLeft(offsetInLine) || bidi.getTextWidth() + this.leftMargin > this.horizontalScrollOffset + this.getClientArea().width || offsetInLine < lineLength)) {
                    --this.caretOffset;
                    this.doSelection(16384);
                    offsetInLine = this.caretOffset - lineOffset;
                    if (offsetInLine > 0 && !bidi.isRightToLeft(offsetInLine)) {
                        ++this.caretOffset;
                        while (this.caretOffset < lineOffset + lineLength && bidi.isRightToLeft(this.caretOffset - lineOffset)) {
                            ++this.caretOffset;
                        }
                    }
                } else if (offsetInLine == 0 && bidi.getCaretPosition(0) != bidi.getTextWidth()) {
                    ++this.caretOffset;
                    while (this.caretOffset < lineOffset + lineLength && bidi.isRightToLeft(this.caretOffset - lineOffset - 1)) {
                        ++this.caretOffset;
                    }
                }
                if (bidi.getCaretPosition(offsetInLine = this.caretOffset - lineOffset) >= this.horizontalScrollOffset) {
                    this.showCaret();
                } else {
                    this.setCaretLocation();
                    this.setBidiKeyboardLanguage();
                }
                if (offsetInLine > 0 && offsetInLine < lineLength - 1) {
                    int clientAreaEnd = this.horizontalScrollOffset + this.getClientArea().width;
                    boolean directionChange = !bidi.isRightToLeft(offsetInLine - 1) && bidi.isRightToLeft(offsetInLine);
                    int textWidth = bidi.getTextWidth() + this.leftMargin;
                    if (directionChange && bidi.isRightToLeft(offsetInLine + 1) && bidi.getCaretPosition(offsetInLine + 1) + this.leftMargin < clientAreaEnd && bidi.getCaretPosition(lineLength) + this.leftMargin < clientAreaEnd && textWidth > clientAreaEnd) {
                        this.scrollHorizontalBar(textWidth - clientAreaEnd);
                    }
                }
            }
            gc.dispose();
        } else if (offsetInLine < lineLength) {
            ++this.caretOffset;
            this.showCaret();
        }
    }

    void doContent(char key) {
        if (this.textLimit > 0 && this.content.getCharCount() - (this.selection.y - this.selection.x) >= this.textLimit) {
            return;
        }
        Event event = new Event();
        event.start = this.selection.x;
        event.end = this.selection.y;
        if (key == '\r' || key == '\n') {
            if (!this.isSingleLine()) {
                event.text = this.getLineDelimiter();
            }
        } else if (this.selection.x == this.selection.y && this.overwrite && key != '\t') {
            String line;
            int lineIndex = this.content.getLineAtOffset(event.end);
            int lineOffset = this.content.getOffsetAtLine(lineIndex);
            if (event.end < lineOffset + (line = this.content.getLine(lineIndex)).length()) {
                ++event.end;
            }
            event.text = new String(new char[]{key});
        } else {
            event.text = new String(new char[]{key});
        }
        if (event.text != null) {
            this.sendKeyEvent(event);
        }
    }

    void doContentEnd() {
        if (this.isSingleLine()) {
            this.doLineEnd();
        } else {
            int length = this.content.getCharCount();
            if (this.caretOffset < length) {
                this.caretOffset = length;
                this.caretLine = this.content.getLineCount() - 1;
                this.showCaret();
            }
        }
    }

    void doContentStart() {
        if (this.caretOffset > 0) {
            this.caretOffset = 0;
            this.caretLine = 0;
            this.showCaret();
        }
    }

    void doCursorPrevious() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.x;
            this.caretLine = this.content.getLineAtOffset(this.caretOffset);
            this.showCaret();
        } else {
            this.doSelectionCursorPrevious();
        }
    }

    void doCursorNext() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.y;
            this.caretLine = this.content.getLineAtOffset(this.caretOffset);
            this.showCaret();
        } else {
            this.doSelectionCursorNext();
        }
    }

    void doDelete() {
        Event event = new Event();
        event.text = "";
        if (this.selection.x != this.selection.y) {
            event.start = this.selection.x;
            event.end = this.selection.y;
            this.sendKeyEvent(event);
        } else if (this.caretOffset < this.content.getCharCount()) {
            int lineLength;
            int line = this.content.getLineAtOffset(this.caretOffset);
            int lineOffset = this.content.getOffsetAtLine(line);
            if (this.caretOffset == lineOffset + (lineLength = this.content.getLine(line).length())) {
                event.start = this.caretOffset;
                event.end = this.content.getOffsetAtLine(line + 1);
            } else {
                event.start = this.caretOffset;
                event.end = this.caretOffset + 1;
            }
            this.sendKeyEvent(event);
        }
    }

    void doLineDown() {
        this.doSelectionLineDown();
        this.showCaret();
    }

    void doLineEnd() {
        int line = this.content.getLineAtOffset(this.caretOffset);
        int lineOffset = this.content.getOffsetAtLine(line);
        int lineLength = this.content.getLine(line).length();
        int lineEndOffset = lineOffset + lineLength;
        if (this.wordWrap && line != this.caretLine) {
            lineEndOffset = this.content.getOffsetAtLine(this.caretLine) + this.content.getLine(this.caretLine).length();
        }
        if (this.caretOffset < lineEndOffset) {
            this.caretOffset = lineEndOffset;
            this.showCaret();
        }
    }

    void doLineStart() {
        int line = this.content.getLineAtOffset(this.caretOffset);
        int lineOffset = this.content.getOffsetAtLine(line);
        if (this.caretOffset > lineOffset && line == this.caretLine) {
            this.caretOffset = lineOffset;
            this.showCaret();
        }
    }

    void doLineUp() {
        int line = this.content.getLineAtOffset(this.caretOffset);
        if (line != this.caretLine) {
            line = this.caretLine;
        }
        if (line > 0) {
            String lineText = this.content.getLine(line);
            int lineOffset = this.content.getOffsetAtLine(line);
            int offsetInLine = this.caretOffset - lineOffset;
            int caretX = this.getXAtOffset(lineText, line, offsetInLine);
            this.caretLine = --line;
            this.caretOffset = this.isBidi() ? this.getBidiOffsetAtMouseLocation(caretX, line) : this.getOffsetAtMouseLocation(caretX, line);
            this.showCaret();
        }
    }

    void doMouseLocationChange(int x, int y, boolean select) {
        int line = (y + this.verticalScrollOffset) / this.lineHeight;
        int lineCount = this.content.getLineCount();
        if (line > lineCount - 1) {
            line = lineCount - 1;
        }
        if (line == 0 || !this.isSingleLine() && line > 0) {
            int newCaretOffset = this.getOffsetAtMouseLocation(x, line);
            if (newCaretOffset != this.caretOffset) {
                this.caretOffset = newCaretOffset;
                this.caretLine = line;
                if (select) {
                    this.doMouseSelection();
                }
                this.setCaretLocation();
            }
            if (!select) {
                this.clearSelection(true);
            }
        }
    }

    void doMouseSelection() {
        if (this.caretOffset <= this.selection.x || this.caretOffset > this.selection.x && this.caretOffset < this.selection.y && this.selectionAnchor == this.selection.x) {
            this.doSelection(16384);
        } else {
            this.doSelection(131072);
        }
    }

    void doPageDown(boolean select) {
        int lineCount;
        int line = this.content.getLineAtOffset(this.caretOffset);
        if (line < (lineCount = this.content.getLineCount()) - 1 && !this.isSingleLine()) {
            int scrollOffset;
            int offsetInLine = this.caretOffset - this.content.getOffsetAtLine(line);
            int verticalMaximum = this.content.getLineCount() * this.getVerticalIncrement();
            int pageSize = this.getClientArea().height;
            int scrollLines = Math.min(lineCount - line - 1, this.getLineCountWhole());
            int caretX = this.getXAtOffset(this.content.getLine(line), line, offsetInLine);
            scrollLines = Math.max(1, scrollLines);
            this.caretLine = line += scrollLines;
            this.caretOffset = this.isBidi() ? this.getBidiOffsetAtMouseLocation(caretX, line) : this.getOffsetAtMouseLocation(caretX, line);
            if (select) {
                this.doSelection(131072);
            }
            if ((scrollOffset = this.verticalScrollOffset + scrollLines * this.getVerticalIncrement()) + pageSize > verticalMaximum) {
                scrollOffset = verticalMaximum - pageSize;
            }
            if (scrollOffset > this.verticalScrollOffset) {
                this.setVerticalScrollOffset(scrollOffset, true);
            } else {
                this.showCaret();
            }
        }
    }

    void doPageEnd() {
        if (this.isSingleLine()) {
            this.doLineEnd();
        } else {
            int line = this.getBottomIndex();
            int bottomCaretOffset = this.content.getOffsetAtLine(line) + this.content.getLine(line).length();
            if (this.caretOffset < bottomCaretOffset) {
                this.caretOffset = bottomCaretOffset;
                this.caretLine = line;
                this.showCaret();
            }
        }
    }

    void doPageStart() {
        int topCaretOffset = this.content.getOffsetAtLine(this.topIndex);
        if (this.caretOffset > topCaretOffset) {
            this.caretOffset = topCaretOffset;
            this.caretLine = this.topIndex;
            this.showCaret();
        }
    }

    void doPageUp() {
        int line = this.content.getLineAtOffset(this.caretOffset);
        if (line > 0) {
            int offsetInLine = this.caretOffset - this.content.getOffsetAtLine(line);
            int scrollLines = Math.max(1, Math.min(line, this.getLineCountWhole()));
            int caretX = this.getXAtOffset(this.content.getLine(line), line, offsetInLine);
            this.caretLine = line -= scrollLines;
            this.caretOffset = this.isBidi() ? this.getBidiOffsetAtMouseLocation(caretX, line) : this.getOffsetAtMouseLocation(caretX, line);
            int scrollOffset = Math.max(0, this.verticalScrollOffset - scrollLines * this.getVerticalIncrement());
            if (scrollOffset < this.verticalScrollOffset) {
                this.setVerticalScrollOffset(scrollOffset, true);
            } else {
                this.showCaret();
            }
        }
    }

    void doSelection(int direction) {
        int redrawStart = -1;
        int redrawEnd = -1;
        if (this.selectionAnchor == -1) {
            this.selectionAnchor = this.selection.x;
        }
        if (direction == 16384) {
            if (this.caretOffset < this.selection.x) {
                redrawEnd = this.selection.x;
                redrawStart = this.selection.x = this.caretOffset;
                if (this.selection.y != this.selectionAnchor) {
                    redrawEnd = this.selection.y;
                    this.selection.y = this.selectionAnchor;
                }
            } else if (this.selectionAnchor == this.selection.x && this.caretOffset < this.selection.y) {
                redrawEnd = this.selection.y;
                redrawStart = this.selection.y = this.caretOffset;
            }
        } else if (this.caretOffset > this.selection.y) {
            redrawStart = this.selection.y;
            redrawEnd = this.selection.y = this.caretOffset;
            if (this.selection.x != this.selectionAnchor) {
                redrawStart = this.selection.x;
                this.selection.x = this.selectionAnchor;
            }
        } else if (this.selectionAnchor == this.selection.y && this.caretOffset > this.selection.x) {
            redrawStart = this.selection.x;
            redrawEnd = this.selection.x = this.caretOffset;
        }
        if (redrawStart != -1 && redrawEnd != -1) {
            this.internalRedrawRange(redrawStart, redrawEnd - redrawStart, true);
            this.sendSelectionEvent();
        }
    }

    void doSelectionCursorNext() {
        int offsetInLine;
        int line = this.content.getLineAtOffset(this.caretOffset);
        if (line != this.caretLine) {
            line = this.caretLine;
        }
        if ((offsetInLine = this.caretOffset - this.content.getOffsetAtLine(line)) < this.content.getLine(line).length()) {
            this.lastCaretDirection = 0x1000004;
            ++this.caretOffset;
            this.showCaret();
        } else if (line < this.content.getLineCount() - 1 && !this.isSingleLine()) {
            this.caretOffset = this.content.getOffsetAtLine(++line);
            this.caretLine = line;
            this.showCaret();
        }
    }

    void doSelectionCursorPrevious() {
        int lineOffset;
        int offsetInLine;
        int line = this.content.getLineAtOffset(this.caretOffset);
        if (line != this.caretLine) {
            line = this.caretLine;
        }
        if ((offsetInLine = this.caretOffset - (lineOffset = this.content.getOffsetAtLine(line))) > 0) {
            this.lastCaretDirection = 0x1000003;
            --this.caretOffset;
            this.showCaret();
        } else if (line > 0) {
            lineOffset = this.content.getOffsetAtLine(--line);
            this.caretOffset = lineOffset + this.content.getLine(line).length();
            this.caretLine = line;
            this.showCaret();
        }
    }

    int doSelectionLineDown() {
        int line = this.content.getLineAtOffset(this.caretOffset);
        if (line != this.caretLine) {
            line = this.caretLine;
        }
        if (!this.isSingleLine() && line < this.content.getLineCount() - 1) {
            String lineText = this.content.getLine(line);
            int offsetInLine = this.caretOffset - this.content.getOffsetAtLine(line);
            int caretX = this.getXAtOffset(lineText, line, offsetInLine);
            this.caretLine = ++line;
            this.caretOffset = this.isBidi() ? this.getBidiOffsetAtMouseLocation(caretX, line) : this.getOffsetAtMouseLocation(caretX, line);
        }
        return line;
    }

    void doSelectionWordNext() {
        int newCaretOffset = this.getWordEnd(this.caretOffset);
        if (!this.isSingleLine() || this.content.getLineAtOffset(this.caretOffset) == this.content.getLineAtOffset(newCaretOffset)) {
            this.lastCaretDirection = 0x1000004;
            this.caretOffset = newCaretOffset;
            this.caretLine = this.content.getLineAtOffset(this.caretOffset);
            this.showCaret();
        }
    }

    void doSelectionWordPrevious() {
        this.lastCaretDirection = 0x1000003;
        this.caretOffset = this.getWordStart(this.caretOffset);
        this.caretLine = this.content.getLineAtOffset(this.caretOffset);
        this.showCaret();
    }

    void doWordNext() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.y;
            this.showCaret();
        } else {
            this.doSelectionWordNext();
        }
    }

    void doWordPrevious() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.x;
            this.showCaret();
        } else {
            this.doSelectionWordPrevious();
        }
    }

    void draw(int x, int y, int width, int height, boolean clearBackground) {
        if (clearBackground) {
            this.redraw(x + this.leftMargin, y + this.topMargin, width, height, true);
        } else {
            int startLine = (y + this.verticalScrollOffset) / this.lineHeight;
            int endY = y + height;
            int paintYFromTopLine = (startLine - this.topIndex) * this.lineHeight;
            int topLineOffset = this.topIndex * this.lineHeight - this.verticalScrollOffset;
            int paintY = paintYFromTopLine + topLineOffset + this.topMargin;
            int lineCount = this.content.getLineCount();
            Color background = this.getBackground();
            Color foreground = this.getForeground();
            GC gc = new GC(this);
            FontData fontData = gc.getFont().getFontData()[0];
            if (this.isSingleLine()) {
                lineCount = 1;
                if (startLine > 1) {
                    startLine = 1;
                }
            }
            int i = startLine;
            while (paintY < endY && i < lineCount) {
                String line = this.content.getLine(i);
                this.renderer.drawLine(line, i, paintY, gc, background, foreground, fontData, clearBackground);
                ++i;
                paintY += this.lineHeight;
            }
            gc.dispose();
        }
    }

    void endAutoScroll() {
        this.autoScrollDirection = 0;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.background == null) {
            return this.getDisplay().getSystemColor(25);
        }
        return this.background;
    }

    public boolean getBidiColoring() {
        this.checkWidget();
        return this.bidiColoring;
    }

    int getBidiOffsetAtMouseLocation(int x, int line) {
        String lineText = this.content.getLine(line);
        int lineOffset = this.content.getOffsetAtLine(line);
        GC gc = new GC(this);
        StyledTextBidi bidi = this.getStyledTextBidi(lineText, lineOffset, gc);
        int[] values = bidi.getCaretOffsetAndDirectionAtX((x += this.horizontalScrollOffset) - this.leftMargin);
        int offsetInLine = values[0];
        this.lastCaretDirection = values[1];
        gc.dispose();
        return lineOffset + offsetInLine;
    }

    int getBottomIndex() {
        int lineCount = 1;
        if (this.lineHeight != 0) {
            int partialTopLineHeight = this.topIndex * this.lineHeight - this.verticalScrollOffset;
            lineCount = (this.getClientArea().height - partialTopLineHeight) / this.lineHeight;
        }
        return Math.min(this.content.getLineCount() - 1, this.topIndex + Math.max(0, lineCount - 1));
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.caretOffset;
    }

    int getCaretOffsetAtX(String line, int lineOffset, int lineXOffset) {
        int offset = 0;
        GC gc = new GC(this);
        FontData currentFont = gc.getFont().getFontData()[0];
        StyleRange[] styles = null;
        StyledTextEvent event = this.renderer.getLineStyleData(lineOffset, line);
        lineXOffset += this.horizontalScrollOffset;
        if (event != null) {
            styles = this.renderer.filterLineStyles(event.styles);
        }
        int low = -1;
        int high = line.length();
        while (high - low > 1) {
            int charWidth;
            offset = (high + low) / 2;
            int x = this.renderer.textWidth(line, lineOffset, 0, offset, styles, 0, gc, currentFont) + this.leftMargin;
            if (lineXOffset <= x + (charWidth = this.renderer.textWidth(line, lineOffset, 0, offset + 1, styles, 0, gc, currentFont) + this.leftMargin - x) / 2) {
                high = offset;
                continue;
            }
            low = offset;
        }
        offset = high;
        gc.dispose();
        return offset;
    }

    int getCaretWidth() {
        Caret caret = this.getCaret();
        if (caret == null) {
            return 0;
        }
        return caret.getSize().x;
    }

    public StyledTextContent getContent() {
        this.checkWidget();
        return this.logicalContent;
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClickEnabled;
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.editable;
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            return this.getDisplay().getSystemColor(24);
        }
        return this.foreground;
    }

    int getHorizontalIncrement() {
        GC gc = new GC(this);
        int increment = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        return increment;
    }

    public int getHorizontalIndex() {
        this.checkWidget();
        return this.horizontalScrollOffset / this.getHorizontalIncrement();
    }

    public int getHorizontalPixel() {
        this.checkWidget();
        return this.horizontalScrollOffset;
    }

    public int getKeyBinding(int key) {
        this.checkWidget();
        Integer action = (Integer)this.keyActionMap.get(new Integer(key));
        int intAction = action == null ? 0 : action;
        return intAction;
    }

    public int getCharCount() {
        this.checkWidget();
        return this.content.getCharCount();
    }

    public Color getLineBackground(int index) {
        this.checkWidget();
        Color lineBackground = null;
        if (index < 0 || index > this.logicalContent.getLineCount()) {
            SWT.error(5);
        }
        if (!this.userLineBackground) {
            lineBackground = this.defaultLineStyler.getLineBackground(index);
        }
        return lineBackground;
    }

    StyledTextEvent getLineBackgroundData(int lineOffset, String line) {
        return this.sendLineEvent(3001, lineOffset, line);
    }

    public int getLineCount() {
        this.checkWidget();
        return this.getLineAtOffset(this.getCharCount()) + 1;
    }

    int getLineCountWhole() {
        int lineCount = this.lineHeight != 0 ? this.getClientArea().height / this.lineHeight : 1;
        return lineCount;
    }

    public int getLineAtOffset(int offset) {
        this.checkWidget();
        if (offset < 0 || offset > this.getCharCount()) {
            SWT.error(6);
        }
        return this.logicalContent.getLineAtOffset(offset);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return this.content.getLineDelimiter();
    }

    StyledTextEvent sendLineEvent(int eventType, int lineOffset, String line) {
        StyledTextEvent event = null;
        if (this.isListening(eventType)) {
            event = new StyledTextEvent(this.logicalContent);
            if (this.wordWrap) {
                int lineIndex = this.logicalContent.getLineAtOffset(lineOffset);
                event.detail = this.logicalContent.getOffsetAtLine(lineIndex);
                event.text = this.logicalContent.getLine(lineIndex);
            } else {
                event.detail = lineOffset;
                event.text = line;
            }
            this.notifyListeners(eventType, event);
        }
        return event;
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.lineHeight;
    }

    LineCache getLineCache(StyledTextContent content) {
        LineCache lineCache = this.wordWrap ? new WordWrapCache(this, (WrappedContent)content) : new ContentWidthCache(this, content.getLineCount());
        return lineCache;
    }

    StyledTextEvent getLineStyleData(int lineOffset, String line) {
        return this.sendLineEvent(3002, lineOffset, line);
    }

    public Point getLocationAtOffset(int offset) {
        this.checkWidget();
        if (offset < 0 || offset > this.getCharCount()) {
            SWT.error(6);
        }
        int line = this.content.getLineAtOffset(offset);
        int lineOffset = this.content.getOffsetAtLine(line);
        String lineContent = this.content.getLine(line);
        int x = this.getXAtOffset(lineContent, line, offset - lineOffset);
        int y = line * this.lineHeight - this.verticalScrollOffset;
        return new Point(x, y);
    }

    public int getOffsetAtLine(int lineIndex) {
        this.checkWidget();
        if (lineIndex < 0 || lineIndex > 0 && lineIndex >= this.logicalContent.getLineCount()) {
            SWT.error(6);
        }
        return this.logicalContent.getOffsetAtLine(lineIndex);
    }

    public int getOffsetAtLocation(Point point) {
        int lineOffset;
        String lineText;
        int offsetInLine;
        int line;
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        if (point.y + this.verticalScrollOffset < 0 || point.x + this.horizontalScrollOffset < 0) {
            SWT.error(5);
        }
        if ((line = (this.getTopPixel() + point.y) / this.lineHeight) >= this.content.getLineCount()) {
            SWT.error(5);
        }
        if ((offsetInLine = this.getOffsetAtX(lineText = this.content.getLine(line), lineOffset = this.content.getOffsetAtLine(line), point.x)) == -1) {
            SWT.error(5);
        }
        return lineOffset + offsetInLine;
    }

    int getOffsetAtMouseLocation(int x, int line) {
        String lineText = this.content.getLine(line);
        int lineOffset = this.content.getOffsetAtLine(line);
        int offsetInLine = this.getCaretOffsetAtX(lineText, lineOffset, x);
        return lineOffset + offsetInLine;
    }

    int getOffsetAtX(String line, int lineOffset, int lineXOffset) {
        int offset;
        GC gc = new GC(this);
        lineXOffset += this.horizontalScrollOffset - this.leftMargin;
        if (this.isBidi()) {
            StyledTextBidi bidi = this.getStyledTextBidi(line, lineOffset, gc);
            offset = bidi.getOffsetAtX(lineXOffset);
        } else {
            FontData currentFont = gc.getFont().getFontData()[0];
            StyleRange[] styles = null;
            StyledTextEvent event = this.renderer.getLineStyleData(lineOffset, line);
            if (event != null) {
                styles = this.renderer.filterLineStyles(event.styles);
            }
            int low = -1;
            int high = line.length();
            while (high - low > 1) {
                offset = (high + low) / 2;
                if (lineXOffset < this.renderer.textWidth(line, lineOffset, 0, offset + 1, styles, 0, gc, currentFont)) {
                    high = offset;
                    continue;
                }
                if (high == line.length() && high - offset == 1) {
                    high = -1;
                    continue;
                }
                low = offset;
            }
            offset = high;
        }
        gc.dispose();
        return offset;
    }

    int getPartialBottomIndex() {
        int partialLineCount = Compatibility.ceil(this.getClientArea().height, this.lineHeight);
        return Math.min(this.content.getLineCount(), this.topIndex + partialLineCount) - 1;
    }

    String getPlatformDelimitedText(TextWriter writer) {
        int end = writer.getStart() + writer.getCharCount();
        int startLine = this.logicalContent.getLineAtOffset(writer.getStart());
        int endLine = this.logicalContent.getLineAtOffset(end);
        String endLineText = this.logicalContent.getLine(endLine);
        int endLineOffset = this.logicalContent.getOffsetAtLine(endLine);
        int i = startLine;
        while (i <= endLine) {
            writer.writeLine(this.logicalContent.getLine(i), this.logicalContent.getOffsetAtLine(i));
            if (i < endLine) {
                writer.writeLineDelimiter(PlatformLineDelimiter);
            }
            ++i;
        }
        if (end > endLineOffset + endLineText.length()) {
            writer.writeLineDelimiter(PlatformLineDelimiter);
        }
        writer.close();
        return writer.toString();
    }

    public Point getSelection() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y);
    }

    public Point getSelectionRange() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y - this.selection.x);
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.getSelectionRange().y;
    }

    public String getSelectionText() {
        this.checkWidget();
        return this.content.getTextRange(this.selection.x, this.selection.y - this.selection.x);
    }

    int[] getBidiSegments(int lineOffset, String line) {
        int[] segments;
        if (!this.isListening(3007)) {
            return this.getBidiSegmentsCompatibility(line, lineOffset);
        }
        StyledTextEvent event = this.sendLineEvent(3007, lineOffset, line);
        int lineLength = line.length();
        if (event == null || event.segments == null || event.segments.length == 0) {
            int[] nArray = new int[2];
            nArray[1] = lineLength;
            segments = nArray;
        } else {
            int segmentCount = event.segments.length;
            if (event.segments[0] != 0) {
                SWT.error(5);
            }
            int i = 1;
            while (i < segmentCount) {
                if (event.segments[i] <= event.segments[i - 1] || event.segments[i] > lineLength) {
                    SWT.error(5);
                }
                ++i;
            }
            if (event.segments[segmentCount - 1] != lineLength) {
                segments = new int[segmentCount + 1];
                System.arraycopy(event.segments, 0, segments, 0, segmentCount);
                segments[segmentCount] = lineLength;
            } else {
                segments = event.segments;
            }
        }
        return segments;
    }

    int[] getBidiSegmentsCompatibility(String line, int lineOffset) {
        StyleRange[] styles = new StyleRange[]{};
        int lineLength = line.length();
        if (!this.bidiColoring) {
            int[] nArray = new int[2];
            nArray[1] = lineLength;
            return nArray;
        }
        StyledTextEvent event = this.renderer.getLineStyleData(lineOffset, line);
        if (event != null) {
            styles = event.styles;
        }
        if (styles.length == 0) {
            int[] nArray = new int[2];
            nArray[1] = lineLength;
            return nArray;
        }
        int k = 0;
        int count = 1;
        while (k < styles.length && styles[k].start == 0 && styles[k].length == lineLength) {
            ++k;
        }
        int[] offsets = new int[(styles.length - k) * 2 + 2];
        int i = k;
        while (i < styles.length) {
            StyleRange style = styles[i];
            int styleLineStart = Math.max(style.start - lineOffset, 0);
            int styleLineEnd = Math.max(style.start + style.length - lineOffset, styleLineStart);
            styleLineEnd = Math.min(styleLineEnd, line.length());
            if (i > 0 && count > 1 && (styleLineStart >= offsets[count - 2] && styleLineStart <= offsets[count - 1] || styleLineEnd >= offsets[count - 2] && styleLineEnd <= offsets[count - 1]) && style.similarTo(styles[i - 1])) {
                offsets[count - 2] = Math.min(offsets[count - 2], styleLineStart);
                offsets[count - 1] = Math.max(offsets[count - 1], styleLineEnd);
            } else {
                if (styleLineStart > offsets[count - 1]) {
                    offsets[count] = styleLineStart;
                    ++count;
                }
                offsets[count] = styleLineEnd;
                ++count;
            }
            ++i;
        }
        if (lineLength > offsets[count - 1]) {
            offsets[count] = lineLength;
            ++count;
        }
        if (count == offsets.length) {
            return offsets;
        }
        int[] result = new int[count];
        System.arraycopy(offsets, 0, result, 0, count);
        return result;
    }

    public StyleRange getStyleRangeAtOffset(int offset) {
        this.checkWidget();
        if (offset < 0 || offset >= this.getCharCount()) {
            SWT.error(5);
        }
        if (!this.userLineStyle) {
            return this.defaultLineStyler.getStyleRangeAtOffset(offset);
        }
        return null;
    }

    public StyleRange[] getStyleRanges() {
        this.checkWidget();
        StyleRange[] styles = !this.userLineStyle ? this.defaultLineStyler.getStyleRanges() : new StyleRange[]{};
        return styles;
    }

    StyledTextBidi getStyledTextBidi(String lineText, int lineOffset, GC gc) {
        return this.getStyledTextBidi(lineText, lineOffset, gc, null);
    }

    StyledTextBidi getStyledTextBidi(String lineText, int lineOffset, GC gc, StyleRange[] styles) {
        return this.renderer.getStyledTextBidi(lineText, lineOffset, gc, styles);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabLength;
    }

    public String getText() {
        this.checkWidget();
        return this.content.getTextRange(0, this.getCharCount());
    }

    public String getText(int start, int end) {
        this.checkWidget();
        int contentLength = this.getCharCount();
        if (start < 0 || start >= contentLength || end < 0 || end >= contentLength || start > end) {
            SWT.error(6);
        }
        return this.content.getTextRange(start, end - start + 1);
    }

    public String getTextRange(int start, int length) {
        this.checkWidget();
        int contentLength = this.getCharCount();
        int end = start + length;
        if (start > end || start < 0 || end > contentLength) {
            SWT.error(6);
        }
        return this.content.getTextRange(start, length);
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getTopIndex() {
        this.checkWidget();
        int logicalTopIndex = this.topIndex;
        if (this.wordWrap) {
            int visualLineOffset = this.content.getOffsetAtLine(this.topIndex);
            logicalTopIndex = this.logicalContent.getLineAtOffset(visualLineOffset);
        }
        return logicalTopIndex;
    }

    public int getTopPixel() {
        this.checkWidget();
        return this.verticalScrollOffset;
    }

    int getVerticalIncrement() {
        return this.lineHeight;
    }

    int getWordEnd(int offset) {
        int line = this.logicalContent.getLineAtOffset(offset);
        int lineOffset = this.logicalContent.getOffsetAtLine(line);
        String lineText = this.logicalContent.getLine(line);
        int lineLength = lineText.length();
        if (offset >= this.getCharCount()) {
            return offset;
        }
        if (offset == lineOffset + lineLength) {
            offset = this.logicalContent.getOffsetAtLine(++line);
        } else {
            char ch = lineText.charAt(offset -= lineOffset);
            boolean letterOrDigit = Compatibility.isLetterOrDigit(ch);
            while (offset < lineLength - 1 && Compatibility.isLetterOrDigit(ch) == letterOrDigit) {
                ch = lineText.charAt(++offset);
            }
            while (offset < lineLength - 1 && Compatibility.isSpaceChar(ch)) {
                ch = lineText.charAt(++offset);
            }
            if (offset == lineLength - 1 && (Compatibility.isLetterOrDigit(ch) == letterOrDigit || Compatibility.isSpaceChar(ch))) {
                ++offset;
            }
            offset += lineOffset;
        }
        return offset;
    }

    int getWordEndNoSpaces(int offset) {
        int line = this.logicalContent.getLineAtOffset(offset);
        int lineOffset = this.logicalContent.getOffsetAtLine(line);
        String lineText = this.logicalContent.getLine(line);
        int lineLength = lineText.length();
        if (offset >= this.getCharCount()) {
            return offset;
        }
        if (offset == lineOffset + lineLength) {
            offset = this.logicalContent.getOffsetAtLine(++line);
        } else {
            char ch = lineText.charAt(offset -= lineOffset);
            boolean letterOrDigit = Compatibility.isLetterOrDigit(ch);
            while (offset < lineLength - 1 && Compatibility.isLetterOrDigit(ch) == letterOrDigit && !Compatibility.isSpaceChar(ch)) {
                ch = lineText.charAt(++offset);
            }
            if (offset == lineLength - 1 && Compatibility.isLetterOrDigit(ch) == letterOrDigit && !Compatibility.isSpaceChar(ch)) {
                ++offset;
            }
            offset += lineOffset;
        }
        return offset;
    }

    int getWordStart(int offset) {
        int line = this.logicalContent.getLineAtOffset(offset);
        int lineOffset = this.logicalContent.getOffsetAtLine(line);
        String lineText = this.logicalContent.getLine(line);
        if (offset <= 0) {
            return offset;
        }
        if (offset == lineOffset) {
            lineText = this.logicalContent.getLine(--line);
            offset = this.logicalContent.getOffsetAtLine(line) + lineText.length();
        } else {
            char ch;
            offset -= lineOffset;
            do {
                ch = lineText.charAt(--offset);
            } while (offset > 0 && Compatibility.isSpaceChar(ch));
            boolean letterOrDigit = Compatibility.isLetterOrDigit(ch);
            while (offset > 0 && Compatibility.isLetterOrDigit(ch) == letterOrDigit && !Compatibility.isSpaceChar(ch)) {
                ch = lineText.charAt(--offset);
            }
            if (offset > 0 || Compatibility.isLetterOrDigit(ch) != letterOrDigit) {
                ++offset;
            }
            offset += lineOffset;
        }
        return offset;
    }

    public boolean getWordWrap() {
        this.checkWidget();
        return this.wordWrap;
    }

    int getXAtOffset(String line, int lineIndex, int lineOffset) {
        int x;
        if (lineOffset == 0 && !this.isBidi()) {
            x = this.leftMargin;
        } else {
            GC gc = new GC(this);
            x = this.textWidth(line, lineIndex, Math.min(line.length(), lineOffset), gc) + this.leftMargin;
            gc.dispose();
            if (lineOffset > line.length()) {
                x += this.lineEndSpaceWidth;
            }
        }
        return x - this.horizontalScrollOffset;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        Point sel = this.getSelectionRange();
        this.replaceTextRange(sel.x, sel.y, string);
    }

    void installDefaultContent() {
        this.textChangeListener = new TextChangeListener(){

            public void textChanging(TextChangingEvent event) {
                StyledText.this.handleTextChanging(event);
            }

            public void textChanged(TextChangedEvent event) {
                StyledText.this.handleTextChanged(event);
            }

            public void textSet(TextChangedEvent event) {
                StyledText.this.handleTextSet(event);
            }
        };
        this.logicalContent = this.content = new DefaultContent();
        this.content.addTextChangeListener(this.textChangeListener);
    }

    void installDefaultLineStyler() {
        this.defaultLineStyler = new DefaultLineStyler(this.logicalContent);
        StyledTextListener typedListener = new StyledTextListener(this.defaultLineStyler);
        if (!this.userLineStyle) {
            this.addListener(3002, typedListener);
        }
        if (!this.userLineBackground) {
            this.addListener(3001, typedListener);
        }
    }

    void installListeners() {
        ScrollBar verticalBar = this.getVerticalBar();
        ScrollBar horizontalBar = this.getHorizontalBar();
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handleDispose();
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handleKeyDown(event);
            }
        });
        this.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handleMouseDown(event);
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handleMouseUp(event);
            }
        });
        this.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handleMouseDoubleClick(event);
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handleMouseMove(event);
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handlePaint(event);
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handleResize(event);
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handleTraverse(event);
            }
        });
        if (verticalBar != null) {
            verticalBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StyledText.this.handleVerticalScroll(event);
                }
            });
        }
        if (horizontalBar != null) {
            horizontalBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StyledText.this.handleHorizontalScroll(event);
                }
            });
        }
    }

    StyledTextContent internalGetContent() {
        return this.content;
    }

    int internalGetHorizontalPixel() {
        return this.horizontalScrollOffset;
    }

    int internalGetLastCaretDirection() {
        return this.lastCaretDirection;
    }

    LineCache internalGetLineCache() {
        return this.lineCache;
    }

    Point internalGetSelection() {
        return this.selection;
    }

    boolean internalGetWordWrap() {
        return this.wordWrap;
    }

    void internalRedraw() {
        super.redraw();
    }

    void internalRedrawRange(int start, int length, boolean clearBackground) {
        int offsetInFirstLine;
        int end = start + length;
        int firstLine = this.content.getLineAtOffset(start);
        int lastLine = this.content.getLineAtOffset(end);
        int partialBottomIndex = this.getPartialBottomIndex();
        int partialTopIndex = this.verticalScrollOffset / this.lineHeight;
        if (firstLine > partialBottomIndex || lastLine < partialTopIndex) {
            return;
        }
        if (partialTopIndex > firstLine) {
            firstLine = partialTopIndex;
            offsetInFirstLine = 0;
        } else {
            offsetInFirstLine = start - this.content.getOffsetAtLine(firstLine);
        }
        if (partialBottomIndex + 1 < lastLine) {
            lastLine = partialBottomIndex + 1;
            end = this.content.getOffsetAtLine(lastLine);
        }
        if (this.isBidi()) {
            this.redrawBidiLines(firstLine, offsetInFirstLine, lastLine, end, clearBackground);
        } else {
            this.redrawLines(firstLine, offsetInFirstLine, lastLine, end, clearBackground);
        }
        if (lastLine - firstLine > 1) {
            Rectangle clientArea = this.getClientArea();
            int redrawStopY = lastLine * this.lineHeight - this.verticalScrollOffset;
            int redrawY = (firstLine + 1) * this.lineHeight - this.verticalScrollOffset;
            this.draw(0, redrawY, clientArea.width, redrawStopY - redrawY, clearBackground);
        }
    }

    String getRtf() {
        this.checkWidget();
        RTFWriter rtfWriter = new RTFWriter(0, this.getCharCount());
        return this.getPlatformDelimitedText(rtfWriter);
    }

    void handleDispose() {
        this.clipboard.dispose();
        this.ibeamCursor.dispose();
        if (this.renderer != null) {
            this.renderer.dispose();
            this.renderer = null;
        }
        if (this.content != null) {
            this.content.removeTextChangeListener(this.textChangeListener);
        }
        if (this.leftCaretBitmap != null) {
            this.leftCaretBitmap.dispose();
            this.leftCaretBitmap = null;
        }
        if (this.rightCaretBitmap != null) {
            this.rightCaretBitmap.dispose();
            this.rightCaretBitmap = null;
        }
        if (this.isBidi()) {
            StyledTextBidi.removeLanguageListener(this);
        }
    }

    void handleMouseDoubleClick(Event event) {
        if (event.button != 1 || !this.doubleClickEnabled) {
            return;
        }
        event.y -= this.topMargin;
        this.mouseDoubleClick = true;
        this.caretOffset = this.getWordEndNoSpaces(this.caretOffset);
        this.resetSelection();
        this.caretOffset = this.getWordStart(this.caretOffset);
        this.caretLine = this.content.getLineAtOffset(this.caretOffset);
        this.showCaret();
        this.doMouseSelection();
    }

    void handleMouseDown(Event event) {
        boolean select;
        boolean bl = select = (event.stateMask & 0x20000) != 0;
        if (event.button != 1) {
            return;
        }
        this.mouseDoubleClick = false;
        event.y -= this.topMargin;
        if (this.isBidi()) {
            this.doBidiMouseLocationChange(event.x, event.y, select);
        } else {
            this.doMouseLocationChange(event.x, event.y, select);
        }
    }

    void handleMouseUp(Event event) {
        event.y -= this.topMargin;
        this.endAutoScroll();
    }

    void handleMouseMove(Event event) {
        if (this.mouseDoubleClick || (event.stateMask & 0x80000) == 0) {
            return;
        }
        event.y -= this.topMargin;
        if (this.isBidi()) {
            this.doBidiMouseLocationChange(event.x, event.y, true);
        } else {
            this.doMouseLocationChange(event.x, event.y, true);
        }
        this.doAutoScroll(event);
    }

    void handleHorizontalScroll(Event event) {
        int scrollPixel = this.getHorizontalBar().getSelection() - this.horizontalScrollOffset;
        this.scrollHorizontal(scrollPixel);
    }

    void handleKeyDown(Event event) {
        Event verifyEvent = new Event();
        verifyEvent.character = event.character;
        verifyEvent.keyCode = event.keyCode;
        verifyEvent.stateMask = event.stateMask;
        verifyEvent.doit = true;
        this.notifyListeners(3005, verifyEvent);
        if (verifyEvent.doit) {
            this.handleKey(event);
        }
    }

    void handleKey(Event event) {
        int action = event.keyCode != 0 ? this.getKeyBinding(event.keyCode | event.stateMask) : this.getKeyBinding(event.character | event.stateMask);
        if (action == 0) {
            if (event.character > '\u001f' && event.character != '\u007f' && event.stateMask != 65536 || event.character == '\r' || event.character == '\n' || event.character == '\t') {
                this.doContent(event.character);
            }
        } else {
            this.invokeAction(action);
        }
    }

    void handlePaint(Event event) {
        int startLine = Math.max(0, (event.y - this.topMargin + this.verticalScrollOffset) / this.lineHeight);
        int paintYFromTopLine = (startLine - this.topIndex) * this.lineHeight;
        int topLineOffset = this.topIndex * this.lineHeight - this.verticalScrollOffset;
        int startY = paintYFromTopLine + topLineOffset;
        int renderHeight = event.y + event.height - startY;
        Rectangle clientArea = this.getClientArea();
        if (clientArea.width == 0 || event.height == 0) {
            return;
        }
        this.performPaint(event.gc, startLine, startY, renderHeight);
    }

    void performPaint(GC gc, int startLine, int startY, int renderHeight) {
        int lineCount = this.content.getLineCount();
        int paintY = this.topMargin;
        Rectangle clientArea = this.getClientArea();
        Color background = this.getBackground();
        Color foreground = this.getForeground();
        Font font = gc.getFont();
        FontData fontData = font.getFontData()[0];
        if (clientArea.width == 0 || renderHeight == 0) {
            return;
        }
        if (this.isSingleLine()) {
            lineCount = 1;
            if (startLine > 1) {
                startLine = 1;
            }
        }
        Image lineBuffer = new Image((Device)this.getDisplay(), clientArea.width, renderHeight);
        GC lineGC = new GC(lineBuffer);
        lineGC.setFont(font);
        lineGC.setForeground(foreground);
        lineGC.setBackground(background);
        int i = startLine;
        while (paintY < renderHeight && i < lineCount) {
            String line = this.content.getLine(i);
            this.renderer.drawLine(line, i, paintY, lineGC, background, foreground, fontData, true);
            ++i;
            paintY += this.lineHeight;
        }
        if (paintY < renderHeight) {
            lineGC.setBackground(background);
            lineGC.setForeground(background);
            lineGC.fillRectangle(0, paintY, clientArea.width, renderHeight - paintY);
        }
        gc.drawImage(lineBuffer, 0, startY);
        lineGC.dispose();
        lineBuffer.dispose();
        this.clearMargin(gc, background, clientArea, renderHeight);
    }

    void handleResize(Event event) {
        int oldHeight = this.clientAreaHeight;
        int oldWidth = this.clientAreaWidth;
        this.clientAreaHeight = this.getClientArea().height;
        this.clientAreaWidth = this.getClientArea().width;
        if (this.wordWrap) {
            if (oldWidth != this.clientAreaWidth) {
                this.wordWrapResize(oldWidth);
            }
        } else if (this.clientAreaHeight > oldHeight) {
            int lineCount = this.content.getLineCount();
            int oldBottomIndex = this.topIndex + oldHeight / this.lineHeight;
            int newItemCount = Compatibility.ceil(this.clientAreaHeight - oldHeight, this.lineHeight);
            oldBottomIndex = Math.min(oldBottomIndex, lineCount);
            newItemCount = Math.min(newItemCount, lineCount - oldBottomIndex);
            this.lineCache.calculate(oldBottomIndex, newItemCount);
        }
        this.setScrollBars();
        this.claimBottomFreeSpace();
        this.claimRightFreeSpace();
    }

    void handleTextChanged(TextChangedEvent event) {
        this.lineCache.textChanged(this.lastTextChangeStart, this.lastTextChangeNewLineCount, this.lastTextChangeReplaceLineCount, this.lastTextChangeNewCharCount, this.lastTextChangeReplaceCharCount);
        this.setScrollBars();
        this.updateSelection(this.lastTextChangeStart, this.lastTextChangeReplaceCharCount, this.lastTextChangeNewCharCount);
        if (this.lastTextChangeReplaceLineCount > 0) {
            this.claimBottomFreeSpace();
        }
        if (this.lastTextChangeReplaceCharCount > 0) {
            this.claimRightFreeSpace();
        }
        if (this.lastTextChangeNewLineCount == 0 && this.lastTextChangeReplaceLineCount == 0) {
            int startLine = this.content.getLineAtOffset(this.lastTextChangeStart);
            int startY = startLine * this.lineHeight - this.verticalScrollOffset;
            GC gc = new GC(this);
            Caret caret = this.getCaret();
            boolean caretVisible = caret.getVisible();
            caret.setVisible(false);
            this.performPaint(gc, startLine, startY, this.lineHeight);
            caret.setVisible(caretVisible);
            gc.dispose();
        }
    }

    void handleTextChanging(TextChangingEvent event) {
        boolean isMultiLineChange;
        boolean bl = isMultiLineChange = event.replaceLineCount > 0 || event.newLineCount > 0;
        if (event.replaceCharCount < 0) {
            event.start += event.replaceCharCount;
            event.replaceCharCount *= -1;
        }
        this.lastTextChangeStart = event.start;
        this.lastTextChangeNewLineCount = event.newLineCount;
        this.lastTextChangeNewCharCount = event.newCharCount;
        this.lastTextChangeReplaceLineCount = event.replaceLineCount;
        this.lastTextChangeReplaceCharCount = event.replaceCharCount;
        int firstLine = this.content.getLineAtOffset(event.start);
        int textChangeY = firstLine * this.lineHeight - this.verticalScrollOffset + this.topMargin;
        if (isMultiLineChange) {
            this.redrawMultiLineChange(textChangeY, event.newLineCount, event.replaceLineCount);
        }
        if (this.defaultLineStyler != null) {
            this.defaultLineStyler.textChanging(event);
        }
    }

    void handleTextSet(TextChangedEvent event) {
        this.reset();
    }

    void handleTraverse(Event event) {
        if (this.isSingleLine() && event.detail == 16) {
            event.doit = true;
        }
    }

    void handleVerticalScroll(Event event) {
        this.setVerticalScrollOffset(this.getVerticalBar().getSelection(), false);
    }

    void initializeRenderer() {
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        this.renderer = new DisplayRenderer(this.getDisplay(), this.getFont(), this.isBidi(), this.leftMargin, this, this.tabLength);
        this.lineHeight = this.renderer.getLineHeight();
        this.lineEndSpaceWidth = this.renderer.getLineEndSpaceWidth();
    }

    public void invokeAction(int action) {
        this.checkWidget();
        switch (action) {
            case 0x1000001: {
                this.doLineUp();
                this.clearSelection(true);
                break;
            }
            case 0x1000002: {
                this.doLineDown();
                this.clearSelection(true);
                break;
            }
            case 0x1000007: {
                this.doLineStart();
                this.clearSelection(true);
                break;
            }
            case 0x1000008: {
                this.doLineEnd();
                this.clearSelection(true);
                break;
            }
            case 0x1000003: {
                this.doCursorPrevious();
                this.clearSelection(true);
                break;
            }
            case 0x1000004: {
                this.doCursorNext();
                this.clearSelection(true);
                break;
            }
            case 0x1000005: {
                this.doPageUp();
                this.clearSelection(true);
                break;
            }
            case 0x1000006: {
                this.doPageDown(false);
                this.clearSelection(true);
                break;
            }
            case 17039363: {
                this.doWordPrevious();
                this.clearSelection(true);
                break;
            }
            case 0x1040004: {
                this.doWordNext();
                this.clearSelection(true);
                break;
            }
            case 17039367: {
                this.doContentStart();
                this.clearSelection(true);
                break;
            }
            case 17039368: {
                this.doContentEnd();
                this.clearSelection(true);
                break;
            }
            case 17039365: {
                this.doPageStart();
                this.clearSelection(true);
                break;
            }
            case 17039366: {
                this.doPageEnd();
                this.clearSelection(true);
                break;
            }
            case 0x1020001: {
                this.doLineUp();
                this.doSelection(16384);
                break;
            }
            case 0x1020002: {
                this.doSelectionLineDown();
                this.doSelection(131072);
                this.showCaret();
                break;
            }
            case 16908295: {
                this.doLineStart();
                this.doSelection(16384);
                break;
            }
            case 16908296: {
                this.doLineEnd();
                this.doSelection(131072);
                break;
            }
            case 16908291: {
                this.doSelectionCursorPrevious();
                this.doSelection(16384);
                break;
            }
            case 16908292: {
                this.doSelectionCursorNext();
                this.doSelection(131072);
                break;
            }
            case 16908293: {
                this.doPageUp();
                this.doSelection(16384);
                break;
            }
            case 16908294: {
                this.doPageDown(true);
                break;
            }
            case 17170435: {
                this.doSelectionWordPrevious();
                this.doSelection(16384);
                break;
            }
            case 17170436: {
                this.doSelectionWordNext();
                this.doSelection(131072);
                break;
            }
            case 17170439: {
                this.doContentStart();
                this.doSelection(16384);
                break;
            }
            case 17170440: {
                this.doContentEnd();
                this.doSelection(131072);
                break;
            }
            case 17170437: {
                this.doPageStart();
                this.doSelection(16384);
                break;
            }
            case 0x1060006: {
                this.doPageEnd();
                this.doSelection(131072);
                break;
            }
            case 131199: {
                this.cut();
                break;
            }
            case 17039369: {
                this.copy();
                break;
            }
            case 16908297: {
                this.paste();
                break;
            }
            case 8: {
                this.doBackspace();
                break;
            }
            case 127: {
                this.doDelete();
                break;
            }
            case 0x1000009: {
                this.overwrite = !this.overwrite;
            }
        }
    }

    boolean isBidi() {
        return this.isBidi;
    }

    boolean isLineDelimiter(int offset) {
        int line = this.content.getLineAtOffset(offset);
        int lineOffset = this.content.getOffsetAtLine(line);
        int offsetInLine = offset - lineOffset;
        return offsetInLine > this.content.getLine(line).length();
    }

    boolean isAreaVisible(int firstLine, int lastLine) {
        int partialBottomIndex = this.getPartialBottomIndex();
        int partialTopIndex = this.verticalScrollOffset / this.lineHeight;
        boolean notVisible = firstLine > partialBottomIndex || lastLine < partialTopIndex;
        return !notVisible;
    }

    boolean isRedrawFirstLine(StyleRange[] ranges, int firstLine, int firstLineOffset) {
        int lineEnd = firstLineOffset + this.content.getLine(firstLine).length();
        int i = 0;
        while (i < ranges.length) {
            StyleRange range = ranges[i];
            if (range.start < lineEnd) {
                int rangeEnd = range.start + range.length;
                if (this.isStyleChanging(range, range.start, Math.min(rangeEnd, lineEnd))) {
                    return true;
                }
            } else {
                return false;
            }
            ++i;
        }
        return false;
    }

    boolean isRedrawLastLine(StyleRange[] ranges, int lastLine, int lastLineOffset) {
        int i = ranges.length - 1;
        while (i >= 0) {
            StyleRange range = ranges[i];
            int rangeEnd = range.start + range.length;
            if (rangeEnd < lastLineOffset) break;
            if (this.isStyleChanging(range, Math.max(range.start, lastLineOffset), rangeEnd)) {
                return true;
            }
            --i;
        }
        return false;
    }

    boolean isSingleLine() {
        return (this.getStyle() & 4) != 0;
    }

    boolean isStyleChanging(StyleRange range, int start, int end) {
        this.checkWidget();
        StyleRange[] styles = this.defaultLineStyler.getStyleRangesFor(start, end - start);
        if (styles == null) {
            return range.fontStyle != 0;
        }
        int i = 0;
        while (i < styles.length) {
            StyleRange newStyle = styles[i];
            if (newStyle.fontStyle != range.fontStyle) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void modifyContent(Event event, boolean updateCaret) {
        event.doit = true;
        this.notifyListeners(25, event);
        if (event.doit) {
            StyledTextEvent styledTextEvent = null;
            int replacedLength = event.end - event.start;
            boolean isCharacterRemove = replacedLength == 1 && event.text.length() == 0;
            boolean isBackspace = event.start < this.caretOffset;
            boolean isDirectionBoundary = false;
            if (updateCaret && this.isBidi() && isCharacterRemove) {
                int line = this.content.getLineAtOffset(this.caretOffset);
                int lineStartOffset = this.content.getOffsetAtLine(line);
                int offsetInLine = this.caretOffset - lineStartOffset;
                String lineText = this.content.getLine(line);
                GC gc = new GC(this);
                StyledTextBidi bidi = new StyledTextBidi(gc, lineText, this.getBidiSegments(lineStartOffset, lineText));
                if (isBackspace) {
                    if (offsetInLine > 0) {
                        isDirectionBoundary = offsetInLine < lineText.length() && (bidi.isRightToLeft(offsetInLine) != bidi.isRightToLeft(offsetInLine - 1) || bidi.isLocalNumber(offsetInLine) != bidi.isLocalNumber(offsetInLine - 1));
                        bidi.setKeyboardLanguage(offsetInLine - 1);
                    }
                } else if (offsetInLine < lineText.length()) {
                    isDirectionBoundary = offsetInLine > 0 && (bidi.isRightToLeft(offsetInLine) != bidi.isRightToLeft(offsetInLine - 1) || bidi.isLocalNumber(offsetInLine) != bidi.isLocalNumber(offsetInLine - 1));
                    bidi.setKeyboardLanguage(offsetInLine);
                }
                gc.dispose();
            }
            if (this.isListening(3000)) {
                styledTextEvent = new StyledTextEvent(this.logicalContent);
                styledTextEvent.start = event.start;
                styledTextEvent.end = event.start + event.text.length();
                styledTextEvent.text = this.content.getTextRange(event.start, replacedLength);
            }
            this.content.replaceTextRange(event.start, replacedLength, event.text);
            if (updateCaret) {
                this.internalSetSelection(event.start + event.text.length(), 0, true);
                if (this.isBidi()) {
                    if (isCharacterRemove) {
                        this.updateBidiDirection(isBackspace, isDirectionBoundary);
                    } else {
                        this.lastCaretDirection = 0x1000004;
                    }
                    this.showBidiCaret();
                } else {
                    this.showCaret();
                }
            }
            this.notifyListeners(24, event);
            if (this.isListening(3000)) {
                this.notifyListeners(3000, styledTextEvent);
            }
        }
    }

    public void paste() {
        this.checkWidget();
        TextTransfer transfer = TextTransfer.getInstance();
        String text = (String)this.clipboard.getContents(transfer);
        if (text != null && text.length() > 0) {
            Event event = new Event();
            event.start = this.selection.x;
            event.end = this.selection.y;
            event.text = this.getModelDelimitedText(text);
            this.sendKeyEvent(event);
        }
    }

    public void print() {
        this.checkWidget();
        Printer printer = new Printer();
        new Printing(this, printer).run();
        printer.dispose();
    }

    public Runnable print(Printer printer) {
        this.checkWidget();
        if (printer == null) {
            SWT.error(4);
        }
        return new Printing(this, printer);
    }

    public void redraw() {
        super.redraw();
        int itemCount = this.getPartialBottomIndex() - this.topIndex + 1;
        this.lineCache.redrawReset(this.topIndex, itemCount, true);
        this.lineCache.calculate(this.topIndex, itemCount);
        this.setHorizontalScrollBar();
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        super.redraw(x, y, width, height, all);
        if (height > 0) {
            int lineCount = this.content.getLineCount();
            int startLine = (this.getTopPixel() + y) / this.lineHeight;
            int endLine = startLine + Compatibility.ceil(height, this.lineHeight);
            startLine = Math.min(startLine, lineCount);
            int itemCount = Math.min(endLine, lineCount) - startLine;
            this.lineCache.reset(startLine, itemCount, true);
            itemCount = this.getPartialBottomIndex() - this.topIndex + 1;
            this.lineCache.calculate(this.topIndex, itemCount);
            this.setHorizontalScrollBar();
        }
    }

    void redrawBidiLines(int firstLine, int offsetInFirstLine, int lastLine, int endOffset, boolean clearBackground) {
        int lastLineOffset;
        int offsetInLastLine;
        int lineCount = lastLine - firstLine + 1;
        int redrawY = firstLine * this.lineHeight - this.verticalScrollOffset;
        int firstLineOffset = this.content.getOffsetAtLine(firstLine);
        String line = this.content.getLine(firstLine);
        GC gc = new GC(this);
        StyledTextBidi bidi = this.getStyledTextBidi(line, firstLineOffset, gc);
        bidi.redrawRange(this, offsetInFirstLine, Math.min(line.length(), endOffset) - offsetInFirstLine, this.leftMargin - this.horizontalScrollOffset, redrawY + this.topMargin, this.lineHeight);
        if (lastLine > firstLine && clearBackground) {
            int lineBreakStartX = bidi.getTextWidth();
            if (lineBreakStartX == this.leftMargin) {
                lineBreakStartX += 3;
            }
            int lineBreakWidth = (this.getStyle() & 0x10000) != 0 ? this.getClientArea().width - (lineBreakStartX -= this.horizontalScrollOffset) : this.lineEndSpaceWidth;
            this.draw(lineBreakStartX, redrawY, lineBreakWidth, this.lineHeight, clearBackground);
        }
        if (lineCount > 1 && (offsetInLastLine = endOffset - (lastLineOffset = this.content.getOffsetAtLine(lastLine))) > 0) {
            line = this.content.getLine(lastLine);
            redrawY = lastLine * this.lineHeight - this.verticalScrollOffset;
            bidi = this.getStyledTextBidi(line, lastLineOffset, gc);
            bidi.redrawRange(this, 0, offsetInLastLine, this.leftMargin - this.horizontalScrollOffset, redrawY + this.topMargin, this.lineHeight);
        }
        gc.dispose();
    }

    void redrawLine(int line, int offset) {
        int redrawX = 0;
        if (offset > 0) {
            String lineText = this.content.getLine(line);
            redrawX = this.getXAtOffset(lineText, line, offset);
        }
        int redrawY = line * this.lineHeight - this.verticalScrollOffset;
        super.redraw(redrawX + this.leftMargin, redrawY + this.topMargin, this.getClientArea().width, this.lineHeight, true);
    }

    void redrawLines(int firstLine, int offsetInFirstLine, int lastLine, int endOffset, boolean clearBackground) {
        int offsetInLastLine;
        boolean fullLineRedraw;
        String line = this.content.getLine(firstLine);
        int lineCount = lastLine - firstLine + 1;
        int redrawX = this.getXAtOffset(line, firstLine, offsetInFirstLine) - this.leftMargin;
        int redrawY = firstLine * this.lineHeight - this.verticalScrollOffset;
        int firstLineOffset = this.content.getOffsetAtLine(firstLine);
        boolean bl = fullLineRedraw = (this.getStyle() & 0x10000) != 0 && lastLine > firstLine;
        if (clearBackground && endOffset - firstLineOffset >= line.length()) {
            fullLineRedraw = true;
        }
        int redrawStopX = fullLineRedraw ? this.getClientArea().width - this.leftMargin : this.getXAtOffset(line, firstLine, endOffset - firstLineOffset) - this.leftMargin;
        this.draw(redrawX, redrawY, redrawStopX - redrawX, this.lineHeight, clearBackground);
        if (lineCount > 1 && (offsetInLastLine = endOffset - this.content.getOffsetAtLine(lastLine)) > 0) {
            line = this.content.getLine(lastLine);
            if (clearBackground && offsetInLastLine >= line.length()) {
                fullLineRedraw = true;
            }
            redrawStopX = fullLineRedraw ? this.getClientArea().width - this.leftMargin : this.getXAtOffset(line, lastLine, offsetInLastLine) - this.leftMargin;
            redrawY = lastLine * this.lineHeight - this.verticalScrollOffset;
            this.draw(0, redrawY, redrawStopX, this.lineHeight, clearBackground);
        }
    }

    void redrawMultiLineChange(int y, int newLineCount, int replacedLineCount) {
        int redrawHeight;
        int redrawStartY;
        int destinationY;
        int sourceY;
        Rectangle clientArea = this.getClientArea();
        int lineCount = newLineCount - replacedLineCount;
        if (lineCount > 0) {
            sourceY = Math.max(0, y + this.lineHeight);
            destinationY = sourceY + lineCount * this.lineHeight;
        } else {
            destinationY = Math.max(0, y + this.lineHeight);
            sourceY = destinationY - lineCount * this.lineHeight;
        }
        this.scroll(0, destinationY, 0, sourceY, clientArea.width, clientArea.height, true);
        if (y + this.lineHeight > 0 && y <= clientArea.height) {
            super.redraw(0, y, clientArea.width, this.lineHeight, true);
        }
        if (newLineCount > 0 && (redrawStartY = y + this.lineHeight) + (redrawHeight = newLineCount * this.lineHeight) > 0 && redrawStartY <= clientArea.height) {
            super.redraw(0, redrawStartY, clientArea.width, redrawHeight, true);
        }
    }

    public void redrawRange(int start, int length, boolean clearBackground) {
        this.checkWidget();
        int end = start + length;
        int contentLength = this.content.getCharCount();
        if (start > end || start < 0 || end > contentLength) {
            SWT.error(6);
        }
        int firstLine = this.content.getLineAtOffset(start);
        int lastLine = this.content.getLineAtOffset(end);
        this.lineCache.reset(firstLine, lastLine - firstLine + 1, true);
        this.internalRedrawRange(start, length, clearBackground);
    }

    public void removeBidiSegmentListener(BidiSegmentListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(3007, listener);
    }

    public void removeExtendedModifyListener(ExtendedModifyListener extendedModifyListener) {
        this.checkWidget();
        if (extendedModifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(3000, extendedModifyListener);
    }

    public void removeLineBackgroundListener(LineBackgroundListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(3001, listener);
        if (!this.isListening(3001) && this.userLineBackground) {
            StyledTextListener typedListener = new StyledTextListener(this.defaultLineStyler);
            this.addListener(3001, typedListener);
            this.userLineBackground = false;
        }
    }

    public void removeLineStyleListener(LineStyleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(3002, listener);
        if (!this.isListening(3002) && this.userLineStyle) {
            StyledTextListener typedListener = new StyledTextListener(this.defaultLineStyler);
            this.addListener(3002, typedListener);
            this.userLineStyle = false;
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(25, verifyListener);
    }

    public void removeVerifyKeyListener(VerifyKeyListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(3005, listener);
    }

    public void replaceStyleRanges(int start, int length, StyleRange[] ranges) {
        int lastLine;
        int firstLine;
        boolean redrawLines;
        this.checkWidget();
        if (this.userLineStyle) {
            return;
        }
        if (ranges == null) {
            SWT.error(4);
        }
        if (ranges.length == 0) {
            this.setStyleRange(new StyleRange(start, length, null, null));
            return;
        }
        int end = start + length;
        if (start > end || start < 0 || end > this.getCharCount()) {
            SWT.error(6);
        }
        if (!(redrawLines = this.isAreaVisible(firstLine = this.content.getLineAtOffset(start), lastLine = this.content.getLineAtOffset(end)))) {
            this.defaultLineStyler.replaceStyleRanges(start, length, ranges);
            this.lineCache.reset(firstLine, lastLine - firstLine + 1, true);
        } else {
            boolean redrawFirstLine = false;
            boolean redrawLastLine = false;
            int firstLineOffset = this.content.getOffsetAtLine(firstLine);
            if (this.isBidi()) {
                redrawFirstLine = true;
                redrawLastLine = true;
            } else {
                int firstLineEnd = firstLineOffset + this.content.getLine(firstLine).length();
                redrawFirstLine = this.isRedrawFirstLine(ranges, firstLine, firstLineOffset);
                StyleRange clearRange = new StyleRange(firstLineOffset, firstLineEnd - firstLineOffset, null, null);
                boolean bl = redrawFirstLine = redrawFirstLine || this.isRedrawFirstLine(new StyleRange[]{clearRange}, firstLine, firstLineOffset);
                if (lastLine != firstLine) {
                    int lastLineOffset = this.content.getOffsetAtLine(lastLine);
                    int lastLineEnd = lastLineOffset + this.content.getLine(lastLine).length();
                    redrawLastLine = this.isRedrawLastLine(ranges, lastLine, lastLineOffset);
                    clearRange = new StyleRange(lastLineOffset, lastLineEnd - lastLineOffset, null, null);
                    redrawLastLine = redrawLastLine || this.isRedrawLastLine(new StyleRange[]{clearRange}, lastLine, lastLineOffset);
                }
            }
            this.defaultLineStyler.replaceStyleRanges(start, length, ranges);
            this.lineCache.reset(firstLine, lastLine - firstLine + 1, true);
            this.internalRedrawRange(start, length, true);
            if (redrawFirstLine) {
                this.redrawLine(firstLine, start - firstLineOffset);
            }
            if (redrawLastLine) {
                this.redrawLine(lastLine, 0);
            }
        }
        this.setCaretLocation();
    }

    public void replaceTextRange(int start, int length, String text) {
        this.checkWidget();
        int contentLength = this.getCharCount();
        int end = start + length;
        Event event = new Event();
        if (start > end || start < 0 || end > contentLength) {
            SWT.error(6);
        }
        if (text == null) {
            SWT.error(4);
        }
        event.start = start;
        event.end = end;
        event.text = text;
        this.modifyContent(event, false);
    }

    void reset() {
        ScrollBar verticalBar = this.getVerticalBar();
        ScrollBar horizontalBar = this.getHorizontalBar();
        this.caretOffset = 0;
        this.caretLine = 0;
        this.topIndex = 0;
        this.verticalScrollOffset = 0;
        this.horizontalScrollOffset = 0;
        this.resetSelection();
        if (this.defaultLineStyler != null) {
            this.removeLineBackgroundListener(this.defaultLineStyler);
            this.removeLineStyleListener(this.defaultLineStyler);
            this.installDefaultLineStyler();
        }
        this.calculateContentWidth();
        if (verticalBar != null) {
            verticalBar.setSelection(0);
        }
        if (horizontalBar != null) {
            horizontalBar.setSelection(0);
        }
        this.setScrollBars();
        this.setCaretLocation();
        super.redraw();
    }

    void resetSelection() {
        this.selection.x = this.selection.y = this.caretOffset;
        this.selectionAnchor = -1;
    }

    void scrollHorizontal(int pixels) {
        if (pixels == 0) {
            return;
        }
        Rectangle clientArea = this.getClientArea();
        if (pixels > 0) {
            int sourceX = this.leftMargin + pixels;
            int scrollWidth = clientArea.width - sourceX - this.rightMargin;
            int scrollHeight = clientArea.height - this.topMargin - this.bottomMargin;
            this.scroll(this.leftMargin, this.topMargin, sourceX, this.topMargin, scrollWidth, scrollHeight, true);
            if (sourceX > scrollWidth) {
                super.redraw(this.leftMargin + scrollWidth, this.topMargin, pixels - scrollWidth, scrollHeight, true);
            }
        } else {
            int destinationX = this.leftMargin - pixels;
            int scrollWidth = clientArea.width - destinationX - this.rightMargin;
            int scrollHeight = clientArea.height - this.topMargin - this.bottomMargin;
            this.scroll(destinationX, this.topMargin, this.leftMargin, this.topMargin, scrollWidth, scrollHeight, true);
            if (destinationX > scrollWidth) {
                super.redraw(this.leftMargin + scrollWidth, this.topMargin, -pixels - scrollWidth, scrollHeight, true);
            }
        }
        this.horizontalScrollOffset += pixels;
        this.setCaretLocation();
    }

    void scrollHorizontalBar(int pixels) {
        if (pixels == 0) {
            return;
        }
        ScrollBar horizontalBar = this.getHorizontalBar();
        if (horizontalBar != null) {
            horizontalBar.setSelection(this.horizontalScrollOffset + pixels);
        }
        this.scrollHorizontal(pixels);
    }

    public void selectAll() {
        this.checkWidget();
        this.setSelection(new Point(0, Math.max(this.getCharCount(), 0)));
    }

    void sendKeyEvent(Event event) {
        if (!this.editable) {
            return;
        }
        this.modifyContent(event, true);
    }

    void sendSelectionEvent() {
        Event event = new Event();
        event.x = this.selection.x;
        event.y = this.selection.y;
        this.notifyListeners(13, event);
    }

    public void setWordWrap(boolean wrap) {
        this.checkWidget();
        if (wrap != this.wordWrap) {
            ScrollBar horizontalBar = this.getHorizontalBar();
            this.wordWrap = wrap;
            if (this.wordWrap) {
                this.logicalContent = this.content;
                this.content = new WrappedContent(this.renderer, this.logicalContent);
            } else {
                this.content = this.logicalContent;
            }
            this.calculateContentWidth();
            this.caretLine = this.content.getLineAtOffset(this.caretOffset);
            this.horizontalScrollOffset = 0;
            if (horizontalBar != null) {
                horizontalBar.setVisible(!this.wordWrap);
            }
            this.setScrollBars();
            this.setCaretLocation();
            super.redraw();
        }
    }

    void showBidiCaret() {
        int line = this.content.getLineAtOffset(this.caretOffset);
        int lineOffset = this.content.getOffsetAtLine(line);
        int offsetInLine = this.caretOffset - lineOffset;
        String lineText = this.content.getLine(line);
        int xAtOffset = 0;
        boolean scrolled = false;
        GC gc = new GC(this);
        StyledTextBidi bidi = this.getStyledTextBidi(lineText, lineOffset, gc);
        xAtOffset = this.renderer.bidiTextWidth(lineText, 0, offsetInLine, 0, bidi) + this.leftMargin;
        if (offsetInLine > lineText.length()) {
            xAtOffset += this.lineEndSpaceWidth;
        }
        if (!(scrolled = this.showLocation(xAtOffset -= this.horizontalScrollOffset, line))) {
            this.setBidiCaretLocation(bidi);
        }
        gc.dispose();
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        super.setCaret(caret);
        if (caret != null) {
            if (!this.isBidi()) {
                caret.setSize(caret.getSize().x, this.lineHeight);
            }
            this.setCaretLocation();
            if (this.isBidi()) {
                this.setBidiKeyboardLanguage();
            }
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this.background = color;
        this.redraw();
    }

    void setBidiCaretLocation(StyledTextBidi bidi) {
        Caret caret = this.getCaret();
        if (caret != null) {
            String lineText = this.content.getLine(this.caretLine);
            int lineStartOffset = this.content.getOffsetAtLine(this.caretLine);
            int offsetInLine = this.caretOffset - lineStartOffset;
            GC gc = null;
            if (bidi == null) {
                gc = new GC(this);
                bidi = this.getStyledTextBidi(lineText, lineStartOffset, gc);
            }
            int caretX = this.lastCaretDirection == 0 ? bidi.getCaretPosition(offsetInLine) + this.leftMargin : bidi.getCaretPosition(offsetInLine, this.lastCaretDirection) + this.leftMargin;
            caretX -= this.horizontalScrollOffset;
            if (StyledTextBidi.getKeyboardLanguageDirection() == 131072) {
                caretX -= this.getCaretWidth() - 1;
            }
            this.createBidiCaret();
            caret.setLocation(caretX, this.caretLine * this.lineHeight - this.verticalScrollOffset + this.topMargin);
            if (gc != null) {
                gc.dispose();
            }
        }
    }

    public void setBidiColoring(boolean mode) {
        this.checkWidget();
        this.bidiColoring = mode;
    }

    void setBidiKeyboardLanguage() {
        int lineStartOffset = this.content.getOffsetAtLine(this.caretLine);
        int offsetInLine = this.caretOffset - lineStartOffset;
        String lineText = this.content.getLine(this.caretLine);
        GC gc = new GC(this);
        int lineLength = lineText.length();
        StyledTextBidi bidi = new StyledTextBidi(gc, lineText, this.getBidiSegments(lineStartOffset, lineText));
        if (offsetInLine == 0) {
            bidi.setKeyboardLanguage(offsetInLine);
        } else if (offsetInLine >= lineLength) {
            offsetInLine = Math.min(offsetInLine, lineLength - 1);
            bidi.setKeyboardLanguage(offsetInLine);
        } else if (this.lastCaretDirection == 0x1000004) {
            bidi.setKeyboardLanguage(offsetInLine - 1);
        } else {
            bidi.setKeyboardLanguage(offsetInLine);
        }
        gc.dispose();
    }

    void setCaretLocation(int caretX, int line) {
        if (this.isBidi()) {
            this.setBidiCaretLocation(null);
        } else {
            Caret caret = this.getCaret();
            if (caret != null) {
                caret.setLocation(caretX, line * this.lineHeight - this.verticalScrollOffset + this.topMargin);
            }
        }
    }

    void setCaretLocation() {
        if (this.isBidi()) {
            this.setBidiCaretLocation(null);
        } else {
            Caret caret = this.getCaret();
            if (caret != null) {
                int lineStartOffset = this.content.getOffsetAtLine(this.caretLine);
                int caretX = this.getXAtOffset(this.content.getLine(this.caretLine), this.caretLine, this.caretOffset - lineStartOffset);
                caret.setLocation(caretX, this.caretLine * this.lineHeight - this.verticalScrollOffset + this.topMargin);
            }
        }
    }

    public void setCaretOffset(int offset) {
        this.checkWidget();
        int length = this.getCharCount();
        if (length > 0 && offset != this.caretOffset) {
            if (offset < 0) {
                this.caretOffset = 0;
                this.caretLine = 0;
            } else if (offset > length) {
                this.caretOffset = length;
                this.caretLine = this.content.getLineCount() - 1;
            } else {
                if (this.isLineDelimiter(offset)) {
                    SWT.error(5);
                }
                this.caretOffset = offset;
                this.caretLine = this.content.getLineAtOffset(this.caretOffset);
            }
            this.clearSelection(false);
        }
        this.setCaretLocation();
        if (this.isBidi()) {
            this.setBidiKeyboardLanguage();
        }
    }

    public void setContent(StyledTextContent newContent) {
        this.checkWidget();
        if (newContent == null) {
            SWT.error(4);
        }
        if (this.content != null) {
            this.content.removeTextChangeListener(this.textChangeListener);
        }
        this.logicalContent = newContent;
        this.content = this.wordWrap ? new WrappedContent(this.renderer, this.logicalContent) : this.logicalContent;
        this.content.addTextChangeListener(this.textChangeListener);
        this.reset();
    }

    public void setDoubleClickEnabled(boolean enable) {
        this.checkWidget();
        this.doubleClickEnabled = enable;
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.editable = editable;
    }

    public void setFont(Font font) {
        this.checkWidget();
        int oldLineHeight = this.lineHeight;
        super.setFont(font);
        this.initializeRenderer();
        if (this.lineHeight != oldLineHeight) {
            this.setVerticalScrollOffset(this.verticalScrollOffset * this.lineHeight / oldLineHeight, true);
            this.claimBottomFreeSpace();
        }
        this.calculateContentWidth();
        this.calculateScrollBars();
        if (this.isBidi()) {
            this.caretDirection = 0;
            this.createCaretBitmaps();
            this.createBidiCaret();
        } else {
            Caret caret = this.getCaret();
            if (caret != null) {
                caret.setSize(caret.getSize().x, this.lineHeight);
            }
        }
        this.setCaretLocation();
        super.redraw();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        this.foreground = color;
        this.redraw();
    }

    public void setHorizontalIndex(int offset) {
        int width;
        this.checkWidget();
        int clientAreaWidth = this.getClientArea().width;
        if (this.getCharCount() == 0) {
            return;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (clientAreaWidth > 0 && (offset *= this.getHorizontalIncrement()) > (width = this.lineCache.getWidth()) - clientAreaWidth) {
            offset = Math.max(0, width - clientAreaWidth);
        }
        this.scrollHorizontalBar(offset - this.horizontalScrollOffset);
    }

    public void setHorizontalPixel(int pixel) {
        int width;
        this.checkWidget();
        int clientAreaWidth = this.getClientArea().width;
        if (this.getCharCount() == 0) {
            return;
        }
        if (pixel < 0) {
            pixel = 0;
        }
        if (clientAreaWidth > 0 && pixel > (width = this.lineCache.getWidth()) - clientAreaWidth) {
            pixel = Math.max(0, width - clientAreaWidth);
        }
        this.scrollHorizontalBar(pixel - this.horizontalScrollOffset);
    }

    void setHorizontalScrollBar() {
        ScrollBar horizontalBar = this.getHorizontalBar();
        if (horizontalBar != null && horizontalBar.getVisible()) {
            Rectangle clientArea = this.getClientArea();
            if (clientArea.width < this.lineCache.getWidth()) {
                horizontalBar.setValues(horizontalBar.getSelection(), horizontalBar.getMinimum(), this.lineCache.getWidth(), clientArea.width - this.leftMargin - this.rightMargin, horizontalBar.getIncrement(), clientArea.width - this.leftMargin - this.rightMargin);
            } else if (horizontalBar.getThumb() != 1 || horizontalBar.getMaximum() != 1) {
                horizontalBar.setValues(horizontalBar.getSelection(), horizontalBar.getMinimum(), 1, 1, horizontalBar.getIncrement(), 1);
            }
        }
    }

    public void setLineBackground(int startLine, int lineCount, Color background) {
        this.checkWidget();
        int partialBottomIndex = this.getPartialBottomIndex();
        if (this.userLineBackground) {
            return;
        }
        if (startLine < 0 || startLine + lineCount > this.logicalContent.getLineCount()) {
            SWT.error(5);
        }
        this.defaultLineStyler.setLineBackground(startLine, lineCount, background);
        if (startLine > partialBottomIndex || startLine + lineCount - 1 < this.topIndex) {
            return;
        }
        if (startLine < this.topIndex) {
            lineCount -= this.topIndex - startLine;
            startLine = this.topIndex;
        }
        if (startLine + lineCount - 1 > partialBottomIndex) {
            lineCount = partialBottomIndex - startLine + 1;
        }
        super.redraw(this.leftMargin, (startLine -= this.topIndex) * this.lineHeight + this.topMargin, this.getClientArea().width - this.leftMargin - this.rightMargin, lineCount * this.lineHeight, true);
    }

    void setScrollBars() {
        ScrollBar verticalBar = this.getVerticalBar();
        if (verticalBar != null) {
            Rectangle clientArea = this.getClientArea();
            int maximum = this.content.getLineCount() * this.getVerticalIncrement();
            if (clientArea.height < maximum) {
                verticalBar.setValues(verticalBar.getSelection(), verticalBar.getMinimum(), maximum, clientArea.height, verticalBar.getIncrement(), clientArea.height);
            } else if (verticalBar.getThumb() != 1 || verticalBar.getMaximum() != 1) {
                verticalBar.setValues(verticalBar.getSelection(), verticalBar.getMinimum(), 1, 1, verticalBar.getIncrement(), 1);
            }
        }
        this.setHorizontalScrollBar();
    }

    public void setSelection(int start) {
        this.setSelection(start, start);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        int contentLength = this.getCharCount();
        if (start > end || start < 0 || end > contentLength) {
            SWT.error(6);
        }
        if (this.isLineDelimiter(start) || this.isLineDelimiter(end)) {
            SWT.error(5);
        }
        this.internalSetSelection(start, end - start, false);
        this.setCaretLocation();
        if (this.isBidi()) {
            this.setBidiKeyboardLanguage();
        }
        this.showSelection();
    }

    public void setSelectionRange(int start, int length) {
        this.checkWidget();
        int contentLength = this.getCharCount();
        int end = start + length;
        if (start > end || start < 0 || end > contentLength) {
            SWT.error(6);
        }
        if (this.isLineDelimiter(start) || this.isLineDelimiter(end)) {
            SWT.error(5);
        }
        this.internalSetSelection(start, length, false);
        this.setCaretLocation();
        if (this.isBidi()) {
            this.setBidiKeyboardLanguage();
        }
    }

    void internalSetSelection(int start, int length, boolean sendEvent) {
        int end = start + length;
        if (this.selection.x != start || this.selection.y != end) {
            this.clearSelection(sendEvent);
            this.selectionAnchor = this.selection.x = start;
            this.caretOffset = this.selection.y = end;
            this.caretLine = this.content.getLineAtOffset(this.caretOffset);
            if (length > 0) {
                this.internalRedrawRange(this.selection.x, this.selection.y - this.selection.x, true);
            }
        }
    }

    public void setStyleRange(StyleRange range) {
        this.checkWidget();
        if (this.userLineStyle) {
            return;
        }
        if (range != null && range.start + range.length > this.content.getCharCount()) {
            SWT.error(6);
        }
        if (range != null) {
            int lastLine;
            boolean redrawFirstLine = false;
            boolean redrawLastLine = false;
            int firstLine = this.content.getLineAtOffset(range.start);
            boolean redrawLines = this.isAreaVisible(firstLine, lastLine = this.content.getLineAtOffset(range.start + range.length));
            if (!redrawLines) {
                this.defaultLineStyler.setStyleRange(range);
                this.lineCache.reset(firstLine, lastLine - firstLine + 1, true);
            } else {
                int firstLineOffset = this.content.getOffsetAtLine(firstLine);
                int lastLineOffset = this.content.getOffsetAtLine(lastLine);
                if (this.isBidi()) {
                    redrawFirstLine = true;
                    redrawLastLine = true;
                } else {
                    redrawFirstLine = this.isRedrawFirstLine(new StyleRange[]{range}, firstLine, firstLineOffset);
                    if (lastLine != firstLine) {
                        redrawLastLine = this.isRedrawLastLine(new StyleRange[]{range}, lastLine, lastLineOffset);
                    }
                }
                this.defaultLineStyler.setStyleRange(range);
                this.lineCache.reset(firstLine, lastLine - firstLine + 1, true);
                this.internalRedrawRange(range.start, range.length, true);
                if (redrawFirstLine) {
                    this.redrawLine(firstLine, range.start - firstLineOffset);
                }
                if (redrawLastLine) {
                    this.redrawLine(lastLine, 0);
                }
            }
        } else {
            this.defaultLineStyler.setStyleRange(range);
            this.lineCache.reset(0, this.content.getLineCount(), false);
            this.redraw();
        }
        this.setCaretLocation();
    }

    public void setStyleRanges(StyleRange[] ranges) {
        this.checkWidget();
        if (this.userLineStyle) {
            return;
        }
        if (ranges == null) {
            SWT.error(4);
        }
        if (ranges.length != 0) {
            StyleRange last = ranges[ranges.length - 1];
            int lastEnd = last.start + last.length;
            int firstLine = this.content.getLineAtOffset(ranges[0].start);
            if (lastEnd > this.content.getCharCount()) {
                SWT.error(6);
            }
            int lastLine = this.content.getLineAtOffset(lastEnd);
            this.lineCache.reset(firstLine, lastLine - firstLine + 1, true);
        } else {
            this.lineCache.reset(0, this.content.getLineCount(), false);
        }
        this.defaultLineStyler.setStyleRanges(ranges);
        this.redraw();
        this.setCaretLocation();
    }

    public void setTabs(int tabs) {
        this.checkWidget();
        this.tabLength = tabs;
        this.renderer.setTabLength(this.tabLength);
        if (this.caretOffset > 0) {
            this.caretOffset = 0;
            this.caretLine = 0;
            if (this.isBidi()) {
                this.showBidiCaret();
            } else {
                this.showCaret();
            }
            this.clearSelection(false);
        }
        this.lineCache.reset(0, this.content.getLineCount(), false);
        this.redraw();
    }

    public void setText(String text) {
        this.checkWidget();
        Event event = new Event();
        if (text == null) {
            SWT.error(4);
        }
        event.start = 0;
        event.end = this.getCharCount();
        event.text = text;
        event.doit = true;
        this.notifyListeners(25, event);
        if (event.doit) {
            StyledTextEvent styledTextEvent = null;
            if (this.isListening(3000)) {
                styledTextEvent = new StyledTextEvent(this.logicalContent);
                styledTextEvent.start = event.start;
                styledTextEvent.end = event.start + event.text.length();
                styledTextEvent.text = this.content.getTextRange(event.start, event.end - event.start);
            }
            this.content.setText(event.text);
            this.notifyListeners(24, event);
            if (styledTextEvent != null) {
                this.notifyListeners(3000, styledTextEvent);
            }
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            SWT.error(7);
        }
        this.textLimit = limit;
    }

    public void setTopIndex(int topIndex) {
        this.checkWidget();
        int lineCount = this.logicalContent.getLineCount();
        int pageSize = Math.min(lineCount, this.getLineCountWhole());
        if (this.getCharCount() == 0) {
            return;
        }
        if (topIndex < 0) {
            topIndex = 0;
        } else if (topIndex > lineCount - pageSize) {
            topIndex = lineCount - pageSize;
        }
        if (this.wordWrap) {
            int logicalLineOffset = this.logicalContent.getOffsetAtLine(topIndex);
            topIndex = this.content.getLineAtOffset(logicalLineOffset);
        }
        this.setVerticalScrollOffset(topIndex * this.getVerticalIncrement(), true);
    }

    public void setTopPixel(int pixel) {
        this.checkWidget();
        int lineCount = this.logicalContent.getLineCount();
        int height = this.getClientArea().height;
        int maxTopPixel = Math.max(0, lineCount * this.getVerticalIncrement() - height);
        if (this.getCharCount() == 0) {
            return;
        }
        if (pixel < 0) {
            pixel = 0;
        } else if (pixel > maxTopPixel) {
            pixel = maxTopPixel;
        }
        this.setVerticalScrollOffset(pixel, true);
    }

    void setVerticalScrollOffset(int pixelOffset, boolean adjustScrollBar) {
        ScrollBar verticalBar = this.getVerticalBar();
        int verticalIncrement = this.getVerticalIncrement();
        if (pixelOffset == this.verticalScrollOffset) {
            return;
        }
        if (verticalBar != null && adjustScrollBar) {
            verticalBar.setSelection(pixelOffset);
        }
        Rectangle clientArea = this.getClientArea();
        this.scroll(0, 0, 0, pixelOffset - this.verticalScrollOffset, clientArea.width, clientArea.height, true);
        if (verticalIncrement != 0) {
            int oldTopIndex = this.topIndex;
            this.topIndex = Compatibility.ceil(pixelOffset, verticalIncrement);
            if (this.topIndex != oldTopIndex) {
                this.lineCache.calculate(this.topIndex, this.getPartialBottomIndex() - this.topIndex + 1);
                this.setHorizontalScrollBar();
            }
        }
        this.verticalScrollOffset = pixelOffset;
        this.setCaretLocation();
    }

    boolean showLocation(int x, int line) {
        int clientAreaWidth = this.getClientArea().width - this.leftMargin - this.rightMargin;
        int verticalIncrement = this.getVerticalIncrement();
        int horizontalIncrement = clientAreaWidth / 4;
        boolean scrolled = false;
        if (x < this.leftMargin) {
            x = Math.max(this.horizontalScrollOffset * -1, x - horizontalIncrement);
            this.scrollHorizontalBar(x);
            scrolled = true;
        } else if (x >= clientAreaWidth) {
            x = Math.min(this.lineCache.getWidth() - this.horizontalScrollOffset, x + horizontalIncrement);
            this.scrollHorizontalBar(x - clientAreaWidth);
            scrolled = true;
        }
        if (line < this.topIndex) {
            this.setVerticalScrollOffset(line * verticalIncrement, true);
            scrolled = true;
        } else if (line > this.getBottomIndex()) {
            this.setVerticalScrollOffset((line + 1) * verticalIncrement - this.getClientArea().height, true);
            scrolled = true;
        }
        return scrolled;
    }

    void showCaret() {
        int offsetInLine;
        int lineOffset = this.content.getOffsetAtLine(this.caretLine);
        String lineText = this.content.getLine(this.caretLine);
        int xAtOffset = this.getXAtOffset(lineText, this.caretLine, offsetInLine = this.caretOffset - lineOffset);
        boolean scrolled = this.showLocation(xAtOffset, this.caretLine);
        if (!scrolled) {
            this.setCaretLocation(xAtOffset, this.caretLine);
        }
        if (this.isBidi()) {
            this.setBidiKeyboardLanguage();
        }
    }

    void showOffset(int offset) {
        int line = this.content.getLineAtOffset(offset);
        int lineOffset = this.content.getOffsetAtLine(line);
        int offsetInLine = offset - lineOffset;
        String lineText = this.content.getLine(line);
        int xAtOffset = this.getXAtOffset(lineText, line, offsetInLine);
        this.showLocation(xAtOffset, line);
    }

    public void showSelection() {
        this.checkWidget();
        this.showOffset(this.selection.x);
        this.showOffset(this.selection.y);
    }

    int textWidth(String line, int lineIndex, int length, GC gc) {
        int width;
        int lineOffset = this.content.getOffsetAtLine(lineIndex);
        int lineLength = line.length();
        if (lineLength == 0 || length > lineLength) {
            return 0;
        }
        if (this.isBidi()) {
            StyledTextBidi bidi = this.getStyledTextBidi(line, lineOffset, gc, null);
            width = this.renderer.bidiTextWidth(line, 0, length, 0, bidi);
        } else {
            StyledTextEvent event = this.renderer.getLineStyleData(lineOffset, line);
            StyleRange[] styles = null;
            if (event != null) {
                styles = this.renderer.filterLineStyles(event.styles);
            }
            width = this.renderer.textWidth(line, lineOffset, 0, length, styles, 0, gc, gc.getFont().getFontData()[0]);
        }
        return width;
    }

    void updateBidiDirection(boolean isBackspace, boolean isDirectionBoundary) {
        this.lastCaretDirection = isDirectionBoundary ? (isBackspace ? 0x1000004 : 0x1000003) : (isBackspace ? 0x1000003 : 0x1000004);
    }

    void updateSelection(int startOffset, int replacedLength, int newLength) {
        if (this.selection.y <= startOffset) {
            return;
        }
        if (this.selection.x < startOffset) {
            this.internalRedrawRange(this.selection.x, startOffset - this.selection.x, true);
        }
        if (this.selection.y > startOffset + replacedLength && this.selection.x < startOffset + replacedLength) {
            int netNewLength = newLength - replacedLength;
            int redrawStart = startOffset + newLength;
            this.internalRedrawRange(redrawStart, this.selection.y + netNewLength - redrawStart, true);
        }
        if (this.selection.y > startOffset && this.selection.x < startOffset + replacedLength) {
            this.internalSetSelection(startOffset + newLength, 0, true);
            this.setCaretLocation();
        } else {
            this.internalSetSelection(this.selection.x + newLength - replacedLength, this.selection.y - this.selection.x, true);
            this.setCaretLocation();
        }
    }

    void wordWrapResize(int oldClientAreaWidth) {
        int newTopIndex;
        String oldCaretLine = this.content.getLine(this.caretLine);
        String topLine = this.content.getLine(this.topIndex);
        int topOffset = this.content.getOffsetAtLine(this.topIndex) + topLine.length();
        WrappedContent wrappedContent = (WrappedContent)this.content;
        if (oldClientAreaWidth != 0 && this.clientAreaWidth > oldClientAreaWidth && wrappedContent.getLineCount() == this.logicalContent.getLineCount()) {
            return;
        }
        wrappedContent.wrapLines();
        if (this.caretLine >= this.content.getLineCount() || !this.content.getLine(this.caretLine).equals(oldCaretLine)) {
            this.caretLine = this.content.getLineAtOffset(this.caretOffset);
            this.setCaretLocation();
        }
        if ((newTopIndex = this.content.getLineAtOffset(topOffset)) != this.topIndex) {
            ScrollBar verticalBar = this.getVerticalBar();
            this.verticalScrollOffset += (newTopIndex - this.topIndex) * this.getVerticalIncrement();
            if (this.verticalScrollOffset < 0) {
                this.verticalScrollOffset = 0;
            }
            this.topIndex = newTopIndex;
            if (verticalBar != null) {
                verticalBar.setSelection(this.verticalScrollOffset);
            }
        }
        super.redraw();
    }

    class Printing
    implements Runnable {
        Printer printer;
        PrintRenderer renderer;
        StyledTextContent printerContent;
        Rectangle clientArea;
        Font printerFont;
        FontData displayFontData;
        Hashtable printerColors;
        Hashtable lineBackgrounds = new Hashtable();
        Hashtable lineStyles = new Hashtable();
        Hashtable bidiSegments = new Hashtable();
        GC gc;
        int startPage;
        int endPage;
        int pageSize;
        int startLine;
        int endLine;
        boolean singleLine;

        Printing(StyledText parent, Printer printer) {
            PrinterData data = printer.getPrinterData();
            this.printer = printer;
            this.singleLine = parent.isSingleLine();
            this.startPage = 1;
            this.endPage = Integer.MAX_VALUE;
            if (data.scope == 1) {
                this.startPage = data.startPage;
                this.endPage = data.endPage;
            }
            this.displayFontData = StyledText.this.getFont().getFontData()[0];
            this.copyContent(parent.getContent());
            this.cacheLineData(this.printerContent);
        }

        void cacheBidiSegments(int lineOffset, String line) {
            int[] segments = StyledText.this.getBidiSegments(lineOffset, line);
            if (segments != null) {
                this.bidiSegments.put(new Integer(lineOffset), segments);
            }
        }

        void cacheLineBackground(int lineOffset, String line) {
            StyledTextEvent event = StyledText.this.getLineBackgroundData(lineOffset, line);
            if (event != null) {
                this.lineBackgrounds.put(new Integer(lineOffset), event);
            }
        }

        void cacheLineData(StyledTextContent printerContent) {
            int i = 0;
            while (i < printerContent.getLineCount()) {
                int lineOffset = printerContent.getOffsetAtLine(i);
                String line = printerContent.getLine(i);
                this.cacheLineBackground(lineOffset, line);
                this.cacheLineStyle(lineOffset, line);
                if (StyledText.this.isBidi()) {
                    this.cacheBidiSegments(lineOffset, line);
                }
                ++i;
            }
        }

        void cacheLineStyle(int lineOffset, String line) {
            StyledTextEvent event = StyledText.this.getLineStyleData(lineOffset, line);
            if (event != null) {
                this.lineStyles.put(new Integer(lineOffset), event);
            }
        }

        void copyContent(StyledTextContent original) {
            original.getLineCount();
            int insertOffset = 0;
            this.printerContent = new DefaultContent();
            int i = 0;
            while (i < original.getLineCount()) {
                int insertEndOffset = i < original.getLineCount() - 1 ? original.getOffsetAtLine(i + 1) : original.getCharCount();
                this.printerContent.replaceTextRange(insertOffset, 0, original.getTextRange(insertOffset, insertEndOffset - insertOffset));
                insertOffset = insertEndOffset;
                ++i;
            }
        }

        void dispose() {
            if (this.printerColors != null) {
                Enumeration colors = this.printerColors.elements();
                while (colors.hasMoreElements()) {
                    Color color = (Color)colors.nextElement();
                    color.dispose();
                }
                this.printerColors = null;
            }
            if (this.gc != null) {
                this.gc.dispose();
                this.gc = null;
            }
            if (this.printerFont != null) {
                this.printerFont.dispose();
                this.printerFont = null;
            }
            if (this.renderer != null) {
                this.renderer.dispose();
                this.renderer = null;
            }
        }

        void initializeRenderer() {
            Rectangle trim = this.printer.computeTrim(0, 0, 0, 0);
            Point dpi = this.printer.getDPI();
            this.printerFont = new Font(this.printer, this.displayFontData.getName(), this.displayFontData.getHeight(), 0);
            this.clientArea = this.printer.getClientArea();
            this.clientArea.x = dpi.x + trim.x;
            this.clientArea.y = dpi.y + trim.y;
            this.clientArea.width -= this.clientArea.x + trim.width;
            this.clientArea.height -= this.clientArea.y + trim.height;
            this.gc = new GC(this.printer);
            this.gc.setFont(this.printerFont);
            this.renderer = new PrintRenderer(this.printer, this.printerFont, StyledText.this.isBidi(), this.gc, this.printerContent, this.lineBackgrounds, this.lineStyles, this.bidiSegments, StyledText.this.tabLength, this.clientArea);
            this.pageSize = this.clientArea.height / this.renderer.getLineHeight();
            this.startLine = (this.startPage - 1) * this.pageSize;
            this.endLine = Math.max(Integer.MAX_VALUE, this.endPage * this.pageSize);
        }

        Color getPrinterColor(Color color) {
            Color printerColor = null;
            if (color != null && (printerColor = (Color)this.printerColors.get(color)) == null) {
                printerColor = new Color(this.printer, color.getRGB());
                this.printerColors.put(color, printerColor);
            }
            return printerColor;
        }

        void createPrinterColors() {
            StyledTextEvent event;
            Enumeration values = this.lineBackgrounds.elements();
            this.printerColors = new Hashtable();
            while (values.hasMoreElements()) {
                event = (StyledTextEvent)values.nextElement();
                event.lineBackground = this.getPrinterColor(event.lineBackground);
            }
            values = this.lineStyles.elements();
            while (values.hasMoreElements()) {
                event = (StyledTextEvent)values.nextElement();
                int i = 0;
                while (i < event.styles.length) {
                    StyleRange style = event.styles[i];
                    Color printerBackground = this.getPrinterColor(style.background);
                    Color printerForeground = this.getPrinterColor(style.foreground);
                    if (printerBackground != style.background || printerForeground != style.foreground) {
                        style = (StyleRange)style.clone();
                        style.background = printerBackground;
                        style.foreground = printerForeground;
                        event.styles[i] = style;
                    }
                    ++i;
                }
            }
        }

        public void run() {
            if (this.printer.startJob("Printing")) {
                this.createPrinterColors();
                this.initializeRenderer();
                this.print();
                this.dispose();
                this.printer.endJob();
            }
        }

        void print() {
            StyledTextContent content = this.renderer.getContent();
            FontData printerFontData = this.gc.getFont().getFontData()[0];
            Color background = this.gc.getBackground();
            Color foreground = this.gc.getForeground();
            int lineHeight = this.renderer.getLineHeight();
            int lineCount = content.getLineCount();
            int paintY = this.clientArea.y;
            if (this.singleLine) {
                lineCount = 1;
            }
            if (this.startPage == 1) {
                this.printer.startPage();
            }
            int i = this.startLine;
            while (i < lineCount && i < this.endLine) {
                String line = content.getLine(i);
                if (paintY + lineHeight > this.clientArea.y + this.clientArea.height) {
                    this.printer.endPage();
                    this.printer.startPage();
                    paintY = this.clientArea.y;
                }
                this.renderer.drawLine(line, i, paintY, this.gc, background, foreground, printerFontData, true);
                ++i;
                paintY += lineHeight;
            }
            if (paintY > this.clientArea.y && paintY <= this.clientArea.y + this.clientArea.height) {
                this.printer.endPage();
            }
        }
    }

    class RTFWriter
    extends TextWriter {
        final int DEFAULT_FOREGROUND = 0;
        final int DEFAULT_BACKGROUND = 1;
        Vector colorTable = new Vector();

        public RTFWriter(int start, int length) {
            super(start, length);
            this.colorTable.addElement(StyledText.this.getForeground());
            this.colorTable.addElement(StyledText.this.getBackground());
        }

        public void close() {
            if (!this.isClosed()) {
                this.writeHeader();
                this.write("\n}}\u0000");
                super.close();
            }
        }

        int getColorIndex(Color color, int defaultIndex) {
            int index;
            if (color == null) {
                index = defaultIndex;
            } else {
                index = this.colorTable.indexOf(color);
                if (index == -1) {
                    index = this.colorTable.size();
                    this.colorTable.addElement(color);
                }
            }
            return index;
        }

        void writeHeader() {
            StringBuffer header = new StringBuffer();
            FontData fontData = StyledText.this.getFont().getFontData()[0];
            header.append("{\\rtf1\\ansi\\deff0{\\fonttbl{\\f0\\fnil");
            String cpg = System.getProperty("file.encoding");
            if (cpg.startsWith("Cp") || cpg.startsWith("MS")) {
                cpg = cpg.substring(2, cpg.length());
                header.append("\\cpg");
                header.append(cpg);
            }
            header.append(" ");
            header.append(fontData.getName());
            header.append(";}}\n{\\colortbl");
            int i = 0;
            while (i < this.colorTable.size()) {
                Color color = (Color)this.colorTable.elementAt(i);
                header.append("\\red");
                header.append(color.getRed());
                header.append("\\green");
                header.append(color.getGreen());
                header.append("\\blue");
                header.append(color.getBlue());
                header.append(";");
                ++i;
            }
            header.append("}\n{\\f0\\fs");
            header.append(fontData.getHeight() * 2);
            header.append(" ");
            this.write(header.toString(), 0);
        }

        public void writeLine(String line, int lineOffset) {
            StyledTextEvent event;
            StyleRange[] styles = new StyleRange[]{};
            Color lineBackground = null;
            if (this.isClosed()) {
                SWT.error(39);
            }
            if ((event = StyledText.this.renderer.getLineStyleData(lineOffset, line)) != null) {
                styles = event.styles;
            }
            if ((event = StyledText.this.renderer.getLineBackgroundData(lineOffset, line)) != null) {
                lineBackground = event.lineBackground;
            }
            if (lineBackground == null) {
                lineBackground = StyledText.this.getBackground();
            }
            this.writeStyledLine(line, lineOffset, styles, lineBackground);
        }

        public void writeLineDelimiter(String lineDelimiter) {
            if (this.isClosed()) {
                SWT.error(39);
            }
            this.write(lineDelimiter, 0, lineDelimiter.length());
            this.write("\\par ");
        }

        void write(String string, int start, int end) {
            int index = start;
            while (index < end) {
                char c = string.charAt(index);
                if (c == '}' || c == '{' || c == '\\') break;
                ++index;
            }
            if (index == end) {
                this.write(string.substring(start, end));
            } else {
                char[] text = new char[end - start];
                string.getChars(start, end, text, 0);
                index = 0;
                while (index < text.length) {
                    switch (text[index]) {
                        case '\\': 
                        case '{': 
                        case '}': {
                            this.write("\\");
                        }
                    }
                    this.write(text[index]);
                    ++index;
                }
            }
        }

        void writeStyledLine(String line, int lineOffset, StyleRange[] styles, Color lineBackground) {
            int copyEnd;
            int lineLength = line.length();
            int startOffset = this.getStart();
            int endOffset = startOffset + super.getCharCount();
            int writeOffset = startOffset - lineOffset;
            if (writeOffset >= line.length()) {
                return;
            }
            int lineIndex = writeOffset > 0 ? writeOffset : 0;
            if (lineBackground != null) {
                this.write("{\\highlight");
                this.write(this.getColorIndex(lineBackground, 1));
                this.write(" ");
            }
            int i = 0;
            while (i < styles.length) {
                StyleRange style = styles[i];
                int start = style.start - lineOffset;
                int end = start + style.length;
                if (end >= writeOffset) {
                    if (style.start > endOffset) break;
                    if (lineIndex < start) {
                        copyEnd = Math.min(start, endOffset - lineOffset);
                        copyEnd = Math.min(copyEnd, lineLength);
                        this.write(line, lineIndex, copyEnd);
                        lineIndex = copyEnd;
                        if (copyEnd != start) break;
                    }
                    int colorIndex = this.getColorIndex(style.background, 1);
                    this.write("{\\cf");
                    this.write(this.getColorIndex(style.foreground, 0));
                    if (colorIndex != 1) {
                        this.write("\\highlight");
                        this.write(colorIndex);
                    }
                    if (style.fontStyle == 1) {
                        this.write("\\b");
                    }
                    this.write(" ");
                    copyEnd = Math.min(end, endOffset - lineOffset);
                    copyEnd = Math.min(copyEnd, lineLength);
                    this.write(line, lineIndex, copyEnd);
                    if (style.fontStyle == 1) {
                        this.write("\\b0");
                    }
                    this.write("}");
                    lineIndex = copyEnd;
                    if (copyEnd != end) break;
                }
                ++i;
            }
            if (lineIndex < (copyEnd = Math.min(lineLength, endOffset - lineOffset))) {
                this.write(line, lineIndex, copyEnd);
            }
            if (lineBackground != null) {
                this.write("}");
            }
        }
    }

    class TextWriter {
        private StringBuffer buffer;
        private int startOffset;
        private int endOffset;
        private boolean isClosed = false;

        public TextWriter(int start, int length) {
            this.buffer = new StringBuffer(length);
            this.startOffset = start;
            this.endOffset = start + length;
        }

        public void close() {
            if (!this.isClosed) {
                this.isClosed = true;
            }
        }

        public int getCharCount() {
            return this.endOffset - this.startOffset;
        }

        public int getStart() {
            return this.startOffset;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public String toString() {
            return this.buffer.toString();
        }

        void write(String string) {
            this.buffer.append(string);
        }

        void write(String string, int offset) {
            if (offset < 0 || offset > this.buffer.length()) {
                return;
            }
            this.buffer.insert(offset, string);
        }

        void write(int i) {
            this.buffer.append(i);
        }

        void write(char i) {
            this.buffer.append(i);
        }

        public void writeLine(String line, int lineOffset) {
            int copyEnd;
            int lineLength = line.length();
            int writeOffset = this.startOffset - lineOffset;
            if (this.isClosed) {
                SWT.error(39);
            }
            if (writeOffset >= lineLength) {
                return;
            }
            int lineIndex = writeOffset > 0 ? writeOffset : 0;
            if (lineIndex < (copyEnd = Math.min(lineLength, this.endOffset - lineOffset))) {
                this.write(line.substring(lineIndex, copyEnd));
            }
        }

        public void writeLineDelimiter(String lineDelimiter) {
            if (this.isClosed) {
                SWT.error(39);
            }
            this.write(lineDelimiter);
        }
    }

    interface LineCache {
        public void calculate(int var1, int var2);

        public int getWidth();

        public void redrawReset(int var1, int var2, boolean var3);

        public void reset(int var1, int var2, boolean var3);

        public void textChanged(int var1, int var2, int var3, int var4, int var5);
    }

    class ContentWidthCache
    implements LineCache {
        StyledText parent;
        int[] lineWidth;
        int lineCount;
        int maxWidth;
        int maxWidthLineIndex;

        public ContentWidthCache(StyledText parent, int lineCount) {
            this.lineCount = lineCount;
            this.parent = parent;
            this.lineWidth = new int[lineCount];
            this.reset(0, lineCount, false);
        }

        public void calculate(int startLine, int lineCount) {
            GC gc = null;
            FontData currentFont = null;
            int caretWidth = 0;
            int stopLine = startLine + lineCount;
            int i = startLine;
            while (i < stopLine) {
                if (this.lineWidth[i] == -1) {
                    String line = StyledText.this.content.getLine(i);
                    int lineOffset = StyledText.this.content.getOffsetAtLine(i);
                    if (gc == null) {
                        gc = new GC(this.parent);
                        caretWidth = StyledText.this.getCaretWidth();
                        if (!StyledText.this.isBidi()) {
                            currentFont = gc.getFont().getFontData()[0];
                        }
                    }
                    this.lineWidth[i] = this.contentWidth(line, lineOffset, gc, currentFont) + caretWidth;
                }
                if (this.lineWidth[i] > this.maxWidth) {
                    this.maxWidth = this.lineWidth[i];
                    this.maxWidthLineIndex = i;
                }
                ++i;
            }
            if (gc != null) {
                gc.dispose();
            }
        }

        void calculateVisible(int startLine, int newLineCount) {
            int topIndex = this.parent.getTopIndex();
            int bottomLine = Math.min(StyledText.this.getPartialBottomIndex(), startLine + newLineCount);
            startLine = Math.max(startLine, topIndex);
            this.calculate(startLine, bottomLine - startLine + 1);
        }

        int contentWidth(String line, int lineOffset, GC gc, FontData currentFont) {
            int width;
            if (StyledText.this.isBidi()) {
                StyledTextBidi bidi = StyledText.this.getStyledTextBidi(line, lineOffset, gc);
                width = bidi.getTextWidth();
            } else {
                StyledTextEvent event = StyledText.this.renderer.getLineStyleData(lineOffset, line);
                StyleRange[] styles = null;
                if (event != null) {
                    styles = StyledText.this.renderer.filterLineStyles(event.styles);
                }
                width = StyledText.this.renderer.textWidth(line, lineOffset, 0, line.length(), styles, 0, gc, currentFont);
            }
            return width + StyledText.this.leftMargin;
        }

        void expandLines(int numLines) {
            int size = this.lineWidth.length;
            if (size - this.lineCount >= numLines) {
                return;
            }
            int[] newLines = new int[Math.max(size * 2, size + numLines)];
            System.arraycopy(this.lineWidth, 0, newLines, 0, size);
            this.lineWidth = newLines;
            this.reset(size, this.lineWidth.length - size, false);
        }

        public int getWidth() {
            return this.maxWidth;
        }

        void linesChanged(int startLine, int delta) {
            boolean inserting;
            boolean bl = inserting = delta > 0;
            if (delta == 0) {
                return;
            }
            if (inserting) {
                this.expandLines(delta);
                int i = this.lineCount - 1;
                while (i >= startLine) {
                    this.lineWidth[i + delta] = this.lineWidth[i];
                    --i;
                }
                i = startLine + 1;
                while (i <= startLine + delta && i < this.lineWidth.length) {
                    this.lineWidth[i] = -1;
                    ++i;
                }
                if (this.maxWidthLineIndex >= startLine) {
                    this.maxWidthLineIndex += delta;
                }
            } else {
                int i = startLine - delta;
                while (i < this.lineCount) {
                    this.lineWidth[i + delta] = this.lineWidth[i];
                    ++i;
                }
                if (this.maxWidthLineIndex > startLine && this.maxWidthLineIndex <= startLine - delta) {
                    this.maxWidth = 0;
                    this.maxWidthLineIndex = -1;
                } else if (this.maxWidthLineIndex >= startLine - delta) {
                    this.maxWidthLineIndex += delta;
                }
            }
            this.lineCount += delta;
        }

        public void redrawReset(int startLine, int lineCount, boolean calculateMaxWidth) {
            this.reset(startLine, lineCount, calculateMaxWidth);
        }

        public void reset(int startLine, int lineCount, boolean calculateMaxWidth) {
            int endLine = startLine + lineCount;
            if (startLine < 0 || endLine > this.lineWidth.length) {
                return;
            }
            int i = startLine;
            while (i < endLine) {
                this.lineWidth[i] = -1;
                ++i;
            }
            if (this.maxWidthLineIndex >= startLine && this.maxWidthLineIndex < endLine) {
                this.maxWidth = 0;
                this.maxWidthLineIndex = -1;
                if (calculateMaxWidth) {
                    i = 0;
                    while (i < lineCount) {
                        if (this.lineWidth[i] > this.maxWidth) {
                            this.maxWidth = this.lineWidth[i];
                            this.maxWidthLineIndex = i;
                        }
                        ++i;
                    }
                }
            }
        }

        public void textChanged(int startOffset, int newLineCount, int replaceLineCount, int newCharCount, int replaceCharCount) {
            boolean removedMaxLine;
            int startLine = this.parent.getLineAtOffset(startOffset);
            boolean bl = removedMaxLine = this.maxWidthLineIndex > startLine && this.maxWidthLineIndex <= startLine + replaceLineCount;
            if (startLine == 0 && replaceLineCount == this.lineCount) {
                this.lineCount = newLineCount;
                this.lineWidth = new int[this.lineCount];
                this.reset(0, this.lineCount, false);
                this.maxWidth = 0;
            } else {
                this.linesChanged(startLine, -replaceLineCount);
                this.linesChanged(startLine, newLineCount);
                this.lineWidth[startLine] = -1;
            }
            this.calculateVisible(startLine, newLineCount);
            if (removedMaxLine || this.maxWidthLineIndex != -1 && this.lineWidth[this.maxWidthLineIndex] < this.maxWidth) {
                this.maxWidth = 0;
                int i = 0;
                while (i < this.lineCount) {
                    if (this.lineWidth[i] > this.maxWidth) {
                        this.maxWidth = this.lineWidth[i];
                        this.maxWidthLineIndex = i;
                    }
                    ++i;
                }
            }
        }
    }

    class WordWrapCache
    implements LineCache {
        StyledText parent;
        WrappedContent visualContent;

        public WordWrapCache(StyledText parent, WrappedContent content) {
            this.parent = parent;
            this.visualContent = content;
            this.visualContent.wrapLines();
        }

        public void calculate(int startLine, int lineCount) {
        }

        public int getWidth() {
            return this.parent.getClientArea().width;
        }

        public void redrawReset(int startLine, int lineCount, boolean calculateMaxWidth) {
            if (lineCount == this.visualContent.getLineCount()) {
                this.visualContent.wrapLines();
            } else {
                this.visualContent.reset(startLine, lineCount);
            }
        }

        public void reset(int startLine, int lineCount, boolean calculateMaxWidth) {
            int cfr_ignored_0 = startLine + lineCount;
            int itemCount = StyledText.this.getPartialBottomIndex() - StyledText.this.topIndex + 1;
            int[] oldLineOffsets = new int[itemCount];
            int i = 0;
            while (i < itemCount) {
                oldLineOffsets[i] = this.visualContent.getOffsetAtLine(i + StyledText.this.topIndex);
                ++i;
            }
            this.redrawReset(startLine, lineCount, calculateMaxWidth);
            if (StyledText.this.getPartialBottomIndex() - StyledText.this.topIndex + 1 != itemCount) {
                this.parent.internalRedraw();
            } else {
                i = 0;
                while (i < itemCount) {
                    if (this.visualContent.getOffsetAtLine(i + StyledText.this.topIndex) != oldLineOffsets[i]) {
                        this.parent.internalRedraw();
                        break;
                    }
                    ++i;
                }
            }
        }

        public void textChanged(int startOffset, int newLineCount, int replaceLineCount, int newCharCount, int replaceCharCount) {
            int startLine = this.visualContent.getLineAtOffset(startOffset);
            this.visualContent.textChanged(startOffset, newLineCount, replaceLineCount, newCharCount, replaceCharCount);
            if (startLine <= StyledText.this.getPartialBottomIndex()) {
                this.parent.internalRedraw();
            }
        }
    }
}

