/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.ACCEL;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MEASUREITEMSTRUCT;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    int id;
    int accelerator;

    public MenuItem(Menu parent, int style) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public MenuItem(Menu parent, int style, int index) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 8, 32, 16, 2, 64, 0);
    }

    void fillAccel(ACCEL accel) {
        accel.fVirt = 0;
        accel.key = 0;
        accel.cmd = 0;
        if (this.accelerator == 0) {
            return;
        }
        boolean fVirt = true;
        int key = this.accelerator & 0xFFF8FFFF;
        int vKey = Display.untranslateKey(key);
        if (vKey != 0) {
            key = vKey;
        } else {
            switch (key) {
                case 27: {
                    key = 27;
                    break;
                }
                case 127: {
                    key = 46;
                    break;
                }
                default: {
                    key = this.wcsToMbcs((char)key);
                    if (key == 0) {
                        return;
                    }
                    if (OS.IsWinCE) {
                        key = OS.CharUpper((short)key);
                        break;
                    }
                    vKey = OS.VkKeyScan((short)key) & 0xFF;
                    if (vKey == -1) {
                        fVirt = false;
                        break;
                    }
                    key = vKey;
                }
            }
        }
        accel.key = (short)key;
        accel.cmd = (short)this.id;
        accel.fVirt = (byte)(fVirt ? 1 : 0);
        if ((this.accelerator & 0x10000) != 0) {
            accel.fVirt = (byte)(accel.fVirt | 0x10);
        }
        if ((this.accelerator & 0x40000) != 0) {
            accel.fVirt = (byte)(accel.fVirt | 8);
        }
        if ((this.accelerator & 0x20000) != 0) {
            accel.fVirt = (byte)(accel.fVirt | 4);
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    public Display getDisplay() {
        Menu parent = this.parent;
        if (parent == null) {
            this.error(24);
        }
        return parent.getDisplay();
    }

    public boolean getEnabled() {
        boolean success;
        this.checkWidget();
        int hMenu = this.parent.handle;
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 1;
        if (OS.IsWinCE) {
            int index = this.parent.indexOf(this);
            if (index == -1) {
                this.error(31);
            }
            success = OS.GetMenuItemInfo(hMenu, index, true, info);
        } else {
            success = OS.GetMenuItemInfo(hMenu, this.id, false, info);
        }
        if (!success) {
            this.error(31);
        }
        return (info.fState & 3) == 0;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        int hMenu = this.parent.handle;
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 1;
        boolean success = OS.GetMenuItemInfo(hMenu, this.id, false, info);
        if (!success) {
            this.error(9);
        }
        return (info.fState & 8) != 0;
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    void releaseChild() {
        super.releaseChild();
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        if (this.menu != null) {
            this.menu.releaseWidget();
            this.menu.releaseHandle();
        }
        this.menu = null;
        super.releaseWidget();
        if (this.accelerator != 0) {
            this.parent.destroyAcceleratorTable();
        }
        this.accelerator = 0;
        Decorations shell = this.parent.parent;
        shell.remove(this);
        this.parent = null;
    }

    public void removeArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAccelerator(int accelerator) {
        this.checkWidget();
        this.accelerator = accelerator;
        this.parent.destroyAcceleratorTable();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        int hMenu = this.parent.handle;
        if (OS.IsWinCE) {
            int index = this.parent.indexOf(this);
            if (index == -1) {
                return;
            }
            int uEnable = 0x400 | (enabled ? 0 : 1);
            OS.EnableMenuItem(hMenu, index, uEnable);
            if (OS.IsPPC) {
                Decorations shell = this.parent.parent;
                if (this.parent == shell.menuBar) {
                    int fsState = OS.SendMessage(shell.hwndTB, 1042, this.id, 0);
                    fsState &= 0xFFFFFFFB;
                    if (enabled) {
                        fsState |= 4;
                    }
                    OS.SendMessage(shell.hwndTB, 1041, this.id, fsState);
                }
            }
        } else {
            MENUITEMINFO info = new MENUITEMINFO();
            info.cbSize = MENUITEMINFO.sizeof;
            info.fMask = 1;
            boolean success = OS.GetMenuItemInfo(hMenu, this.id, false, info);
            if (!success) {
                this.error(30);
            }
            info.fState &= 0xFFFFFFFC;
            if (!enabled) {
                info.fState |= 3;
            }
            if (!(success = OS.SetMenuItemInfo(hMenu, this.id, false, info))) {
                this.error(30);
            }
        }
        this.parent.redraw();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (OS.IsWinCE) {
            return;
        }
        if ((OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) < 262154) {
            return;
        }
        int hMenu = this.parent.handle;
        OS.GetProcessHeap();
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 128;
        if (image != null) {
            info.hbmpItem = -1;
        }
        OS.SetMenuItemInfo(hMenu, this.id, false, info);
        this.parent.redraw();
    }

    public void setMenu(Menu menu) {
        Menu oldMenu;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((oldMenu = this.menu) == menu) {
            return;
        }
        if (oldMenu != null) {
            oldMenu.cascade = null;
        }
        this.menu = menu;
        int hMenu = this.parent.handle;
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 32;
        int index = 0;
        while (OS.GetMenuItemInfo(hMenu, index, true, info)) {
            if (info.dwItemData == this.id) break;
            ++index;
        }
        if (info.dwItemData != this.id) {
            return;
        }
        int cch = 128;
        int hHeap = OS.GetProcessHeap();
        int byteCount = cch * TCHAR.sizeof;
        int pszText = OS.HeapAlloc(hHeap, 8, byteCount);
        info.fMask = 51;
        info.dwTypeData = pszText;
        info.cch = cch;
        boolean success = OS.GetMenuItemInfo(hMenu, index, true, info);
        if (menu != null) {
            menu.cascade = this;
            info.fMask |= 4;
            info.hSubMenu = menu.handle;
        }
        OS.RemoveMenu(hMenu, index, 1024);
        if (OS.IsWinCE) {
            TCHAR lpNewItem;
            int uIDNewItem = this.id;
            int uFlags = 1024;
            if (menu != null) {
                uFlags |= 0x10;
                uIDNewItem = menu.handle;
            }
            if (success = OS.InsertMenu(hMenu, index, uFlags, uIDNewItem, lpNewItem = new TCHAR(0, "", true))) {
                info.fMask = 48;
                success = OS.SetMenuItemInfo(hMenu, index, true, info);
                if ((info.fState & 3) != 0) {
                    OS.EnableMenuItem(hMenu, index, 1025);
                }
                if ((info.fState & 8) != 0) {
                    OS.CheckMenuItem(hMenu, index, 1032);
                }
                if (OS.IsPPC && success) {
                    Decorations shell = this.parent.parent;
                    if (this.parent == shell.menuBar) {
                        OS.SendMessage(shell.hwndCB, 1424, this.id, uIDNewItem);
                    }
                }
            }
        } else {
            success = OS.InsertMenuItem(hMenu, index, true, info);
        }
        if (pszText != 0) {
            OS.HeapFree(hHeap, 0, pszText);
        }
        if (!success) {
            this.error(29);
        }
        this.parent.destroyAcceleratorTable();
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        int hMenu = this.parent.handle;
        if (OS.IsWinCE) {
            int index = this.parent.indexOf(this);
            if (index == -1) {
                return;
            }
            int uCheck = 0x400 | (selected ? 8 : 0);
            OS.CheckMenuItem(hMenu, index, uCheck);
        } else {
            MENUITEMINFO info = new MENUITEMINFO();
            info.cbSize = MENUITEMINFO.sizeof;
            info.fMask = 1;
            boolean success = OS.GetMenuItemInfo(hMenu, this.id, false, info);
            if (!success) {
                this.error(28);
            }
            info.fState &= 0xFFFFFFF7;
            if (selected) {
                info.fState |= 8;
            }
            if (!(success = OS.SetMenuItemInfo(hMenu, this.id, false, info))) {
                this.error(28);
            }
        }
        this.parent.redraw();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setText(string);
        boolean fixPPCMenuBar = false;
        if (OS.IsPPC) {
            Decorations shell = this.parent.parent;
            if (this.parent == shell.menuBar) {
                fixPPCMenuBar = true;
                if (string.indexOf(38) != -1) {
                    int length = string.length();
                    char[] text = new char[length];
                    string.getChars(0, length, text, 0);
                    int i = 0;
                    int j = 0;
                    i = 0;
                    while (i < length) {
                        if (text[i] != '&') {
                            text[j++] = text[i];
                        }
                        ++i;
                    }
                    if (j < i) {
                        string = new String(text, 0, j);
                    }
                }
            }
        }
        int hMenu = this.parent.handle;
        int hHeap = OS.GetProcessHeap();
        TCHAR buffer = new TCHAR(0, string, true);
        int byteCount = buffer.length() * TCHAR.sizeof;
        int pszText = OS.HeapAlloc(hHeap, 8, byteCount);
        OS.MoveMemory(pszText, buffer, byteCount);
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 16;
        info.fType = this.widgetStyle();
        info.dwTypeData = pszText;
        boolean success = OS.SetMenuItemInfo(hMenu, this.id, false, info);
        if (!OS.IsWinCE && (OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) >= 262154 && this.image != null) {
            info.fMask = 128;
            info.hbmpItem = -1;
            success = OS.SetMenuItemInfo(hMenu, this.id, false, info);
        }
        if (fixPPCMenuBar) {
            Decorations shell = this.parent.parent;
            TBBUTTONINFO info2 = new TBBUTTONINFO();
            info2.cbSize = 32;
            info2.dwMask = 2;
            info2.pszText = pszText;
            OS.SendMessage(shell.hwndTB, OS.TB_SETBUTTONINFO, this.id, info2);
        }
        if (pszText != 0) {
            OS.HeapFree(hHeap, 0, pszText);
        }
        if (!success) {
            this.error(13);
        }
        this.parent.redraw();
    }

    int widgetStyle() {
        if ((this.style & 2) != 0) {
            return 2048;
        }
        if ((this.style & 0x10) != 0) {
            return 512;
        }
        return 0;
    }

    LRESULT wmCommandChild(int wParam, int lParam) {
        if ((this.style & 0x30) != 0) {
            this.setSelection(!this.getSelection());
        }
        Event event = new Event();
        if (OS.GetKeyState(18) < 0) {
            event.stateMask |= 0x10000;
        }
        if (OS.GetKeyState(16) < 0) {
            event.stateMask |= 0x20000;
        }
        if (OS.GetKeyState(17) < 0) {
            event.stateMask |= 0x40000;
        }
        if (OS.GetKeyState(1) < 0) {
            event.stateMask |= 0x80000;
        }
        if (OS.GetKeyState(4) < 0) {
            event.stateMask |= 0x100000;
        }
        if (OS.GetKeyState(2) < 0) {
            event.stateMask |= 0x200000;
        }
        this.postEvent(13, event);
        return null;
    }

    LRESULT wmDrawChild(int wParam, int lParam) {
        DRAWITEMSTRUCT struct = new DRAWITEMSTRUCT();
        OS.MoveMemory(struct, lParam, 48);
        if (this.image != null) {
            int hImage = this.image.handle;
            switch (this.image.type) {
                case 0: {
                    BITMAP bm = new BITMAP();
                    OS.GetObject(hImage, 24, bm);
                    int hDC = OS.CreateCompatibleDC(struct.hDC);
                    int oldBitmap = OS.SelectObject(hDC, hImage);
                    OS.BitBlt(struct.hDC, struct.left, struct.top + 2, bm.bmWidth, bm.bmHeight, hDC, 0, 0, 0xCC0020);
                    OS.SelectObject(hDC, oldBitmap);
                    OS.DeleteDC(hDC);
                    break;
                }
                case 1: {
                    OS.DrawIconEx(struct.hDC, struct.left, struct.top + 2, hImage, 0, 0, 0, 0, 3);
                }
            }
        }
        return null;
    }

    LRESULT wmMeasureChild(int wParam, int lParam) {
        MEASUREITEMSTRUCT struct = new MEASUREITEMSTRUCT();
        OS.MoveMemory(struct, lParam, 24);
        if (this.image != null) {
            Rectangle rect = this.image.getBounds();
            struct.itemWidth = rect.width + 4;
            struct.itemHeight = rect.height + 4;
        }
        OS.MoveMemory(lParam, struct, 24);
        return null;
    }
}

