/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.OS;

class ImageList {
    int handle = OS.ImageList_Create(32, 32, CREATE_FLAGS, 16, 16);
    int refCount;
    Image[] images = new Image[4];
    static final int CREATE_FLAGS;

    static {
        if (OS.IsWinCE) {
            CREATE_FLAGS = 1;
        } else {
            int flags = 1;
            int hDC = OS.GetDC(0);
            int bits = OS.GetDeviceCaps(hDC, 12);
            int planes = OS.GetDeviceCaps(hDC, 14);
            OS.ReleaseDC(0, hDC);
            int depth = bits * planes;
            switch (depth) {
                case 4: {
                    flags |= 4;
                    break;
                }
                case 8: {
                    flags |= 8;
                    break;
                }
                case 16: {
                    flags |= 0x10;
                    break;
                }
                case 24: {
                    flags |= 0x18;
                    break;
                }
                case 32: {
                    flags |= 0x20;
                    break;
                }
                default: {
                    flags |= 0;
                }
            }
            CREATE_FLAGS = flags;
        }
    }

    public int add(Image image) {
        int count = OS.ImageList_GetImageCount(this.handle);
        int index = 0;
        while (index < count) {
            if (this.images[index] != null && this.images[index].isDisposed()) {
                this.images[index] = null;
            }
            if (this.images[index] == null) break;
            ++index;
        }
        int[] cx = new int[1];
        int[] cy = new int[1];
        if (count == 0) {
            Rectangle rect = image.getBounds();
            cx[0] = rect.width;
            cy[0] = rect.height;
            OS.ImageList_SetIconSize(this.handle, cx[0], cy[0]);
        }
        int hImage = image.handle;
        OS.ImageList_GetIconSize(this.handle, cx, cy);
        switch (image.type) {
            case 0: {
                int hBitmap = this.copyBitmap(hImage, cx[0], cy[0]);
                int background = -1;
                Color color = image.getBackground();
                if (color != null) {
                    background = color.handle;
                }
                if (index == count) {
                    if (background != -1) {
                        OS.ImageList_AddMasked(this.handle, hBitmap, background);
                    } else {
                        int hMask = this.createMask(hBitmap, cx[0], cy[0], background);
                        OS.ImageList_Add(this.handle, hBitmap, hMask);
                        OS.DeleteObject(hMask);
                    }
                } else {
                    int hMask = this.createMask(hBitmap, cx[0], cy[0], background);
                    OS.ImageList_Replace(this.handle, index, hBitmap, hMask);
                    OS.DeleteObject(hMask);
                }
                OS.DeleteObject(hBitmap);
                break;
            }
            case 1: {
                if (OS.IsWinCE) {
                    OS.ImageList_ReplaceIcon(this.handle, index == count ? -1 : index, hImage);
                    break;
                }
                int hIcon = this.copyIcon(hImage, cx[0], cy[0]);
                OS.ImageList_ReplaceIcon(this.handle, index == count ? -1 : index, hIcon);
                OS.DestroyIcon(hIcon);
            }
        }
        if (index == this.images.length) {
            Image[] newImages = new Image[this.images.length + 4];
            System.arraycopy(this.images, 0, newImages, 0, this.images.length);
            this.images = newImages;
        }
        this.images[index] = image;
        return index;
    }

    int addRef() {
        return ++this.refCount;
    }

    int copyBitmap(int hImage, int width, int height) {
        BITMAP bm = new BITMAP();
        OS.GetObject(hImage, 24, bm);
        int hDC = OS.GetDC(0);
        int hdc1 = OS.CreateCompatibleDC(hDC);
        OS.SelectObject(hdc1, hImage);
        int hdc2 = OS.CreateCompatibleDC(hDC);
        int hBitmap = OS.CreateCompatibleBitmap(hDC, width, height);
        OS.SelectObject(hdc2, hBitmap);
        if (!OS.IsWinCE) {
            OS.SetStretchBltMode(hdc2, 3);
        }
        OS.StretchBlt(hdc2, 0, 0, width, height, hdc1, 0, 0, bm.bmWidth, bm.bmHeight, 0xCC0020);
        OS.DeleteDC(hdc1);
        OS.DeleteDC(hdc2);
        OS.ReleaseDC(0, hDC);
        return hBitmap;
    }

    int copyIcon(int hImage, int width, int height) {
        int hIcon;
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        return (hIcon = OS.CopyImage(hImage, 1, width, height, 0)) != 0 ? hIcon : hImage;
    }

    int createMask(int hBitmap, int width, int height, int background) {
        int hMask = OS.CreateBitmap(width, height, 1, 1, null);
        int hDC = OS.GetDC(0);
        int hdc1 = OS.CreateCompatibleDC(hDC);
        if (background != -1) {
            OS.SelectObject(hdc1, hBitmap);
            int hdc2 = OS.CreateCompatibleDC(hDC);
            OS.SelectObject(hdc2, hMask);
            OS.SetBkColor(hdc1, background);
            OS.BitBlt(hdc2, 0, 0, width, height, hdc1, 0, 0, 0xCC0020);
            OS.DeleteDC(hdc2);
        } else {
            int hOldBitmap = OS.SelectObject(hdc1, hMask);
            OS.PatBlt(hdc1, 0, 0, width, height, 66);
            OS.SelectObject(hdc1, hOldBitmap);
        }
        OS.ReleaseDC(0, hDC);
        OS.DeleteDC(hdc1);
        return hMask;
    }

    public void dispose() {
        if (this.handle != 0) {
            OS.ImageList_Destroy(this.handle);
        }
        this.handle = 0;
        this.images = null;
    }

    public Image get(int index) {
        return this.images[index];
    }

    public int getHandle() {
        return this.handle;
    }

    public Point getImageSize() {
        int[] cx = new int[1];
        int[] cy = new int[1];
        OS.ImageList_GetIconSize(this.handle, cx, cy);
        return new Point(cx[0], cy[0]);
    }

    public int indexOf(Image image) {
        int count = OS.ImageList_GetImageCount(this.handle);
        int i = 0;
        while (i < count) {
            if (this.images[i] != null) {
                if (this.images[i].isDisposed()) {
                    this.images[i] = null;
                }
                if (this.images[i] != null && this.images[i].equals(image)) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public void put(int index, Image image) {
        int count = OS.ImageList_GetImageCount(this.handle);
        if (index < 0 || index >= count) {
            return;
        }
        if (image != null) {
            int[] cx = new int[1];
            int[] cy = new int[1];
            OS.ImageList_GetIconSize(this.handle, cx, cy);
            int hImage = image.handle;
            switch (image.type) {
                case 0: {
                    int background = -1;
                    Color color = image.getBackground();
                    if (color != null) {
                        background = color.handle;
                    }
                    int hBitmap = this.copyBitmap(hImage, cx[0], cy[0]);
                    int hMask = this.createMask(hBitmap, cx[0], cy[0], background);
                    OS.ImageList_Replace(this.handle, index, hBitmap, hMask);
                    OS.DeleteObject(hBitmap);
                    OS.DeleteObject(hMask);
                    break;
                }
                case 1: {
                    if (OS.IsWinCE) {
                        OS.ImageList_ReplaceIcon(this.handle, index, hImage);
                        break;
                    }
                    int hIcon = this.copyIcon(hImage, cx[0], cy[0]);
                    OS.ImageList_ReplaceIcon(this.handle, index, hIcon);
                    OS.DestroyIcon(hIcon);
                }
            }
        }
        this.images[index] = image;
    }

    public void remove(int index) {
        int count = OS.ImageList_GetImageCount(this.handle);
        if (index < 0 || index >= count) {
            return;
        }
        OS.ImageList_Remove(this.handle, index);
        System.arraycopy(this.images, index + 1, this.images, index, --count - index);
        this.images[index] = null;
    }

    int removeRef() {
        return --this.refCount;
    }

    public int size() {
        int result = 0;
        int count = OS.ImageList_GetImageCount(this.handle);
        int i = 0;
        while (i < count) {
            if (this.images[i] != null) {
                if (this.images[i].isDisposed()) {
                    this.images[i] = null;
                }
                if (this.images[i] == null) {
                    ++result;
                }
            }
            ++i;
        }
        return result;
    }
}

