/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PRINTDLG;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    int scope = 0;
    int startPage = -1;
    int endPage = -1;
    boolean printToFile = false;

    public PrintDialog(Shell parent) {
        this(parent, 32768);
    }

    public PrintDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPage) {
        this.endPage = endPage;
    }

    public boolean getPrintToFile() {
        return this.printToFile;
    }

    public void setPrintToFile(boolean printToFile) {
        this.printToFile = printToFile;
    }

    protected void checkSubclass() {
    }

    public PrinterData open() {
        PRINTDLG pd = new PRINTDLG();
        pd.lStructSize = 66;
        pd.Flags = 262144;
        if (this.printToFile) {
            pd.Flags |= 0x20;
        }
        switch (this.scope) {
            case 1: {
                pd.Flags |= 2;
                break;
            }
            case 2: {
                pd.Flags |= 1;
                break;
            }
            default: {
                pd.Flags |= 0;
            }
        }
        pd.nMinPage = 1;
        pd.nMaxPage = (short)-1;
        pd.nFromPage = (short)this.startPage;
        pd.nToPage = (short)this.endPage;
        if (OS.PrintDlg(pd)) {
            int size = OS.GlobalSize(pd.hDevNames);
            int ptr = OS.GlobalLock(pd.hDevNames);
            short[] offsets = new short[4];
            OS.MoveMemory(offsets, ptr, 2 * offsets.length);
            TCHAR buffer = new TCHAR(0, size);
            OS.MoveMemory(buffer, ptr, size);
            OS.GlobalUnlock(ptr);
            short driverOffset = offsets[0];
            int i = 0;
            while (driverOffset + i < size) {
                if (buffer.tcharAt(driverOffset + i) == 0) break;
                ++i;
            }
            String driver = buffer.toString(driverOffset, i);
            short deviceOffset = offsets[1];
            i = 0;
            while (deviceOffset + i < size) {
                if (buffer.tcharAt(deviceOffset + i) == 0) break;
                ++i;
            }
            String device = buffer.toString(deviceOffset, i);
            short outputOffset = offsets[2];
            i = 0;
            while (outputOffset + i < size) {
                if (buffer.tcharAt(outputOffset + i) == 0) break;
                ++i;
            }
            String output = buffer.toString(outputOffset, i);
            PrinterData data = new PrinterData(driver, device);
            if ((pd.Flags & 2) != 0) {
                data.scope = 1;
                data.startPage = pd.nFromPage;
                data.endPage = pd.nToPage;
            } else if ((pd.Flags & 1) != 0) {
                data.scope = 2;
            }
            boolean bl = data.printToFile = (pd.Flags & 0x20) != 0;
            if (data.printToFile) {
                data.fileName = output;
            }
            data.copyCount = pd.nCopies;
            data.collate = (pd.Flags & 0x10) != 0;
            ptr = OS.GlobalLock(pd.hDevMode);
            size = OS.GlobalSize(ptr);
            data.otherData = new byte[size];
            OS.MoveMemory(data.otherData, ptr, size);
            OS.GlobalUnlock(ptr);
            return data;
        }
        return null;
    }
}

