/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Vector;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextBidi;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

class DisplayRenderer
extends StyledTextRenderer {
    private StyledText parent;

    DisplayRenderer(Device device, Font regularFont, boolean isBidi, int leftMargin, StyledText parent, int tabLength) {
        super(device, regularFont, isBidi, leftMargin);
        this.parent = parent;
        this.calculateLineHeight();
        this.setTabLength(tabLength);
    }

    protected void disposeGC(GC gc) {
        gc.dispose();
    }

    protected void drawLineSelectionBackground(String line, int lineOffset, StyleRange[] styles, int paintY, GC gc, FontData currentFont, StyledTextBidi bidi) {
        Point selection = this.parent.internalGetSelection();
        StyledText.LineCache lineCache = this.parent.internalGetLineCache();
        StyledTextContent content = this.getContent();
        int lineLength = line.length();
        int selectionBackgroundWidth = -1;
        int selectionStart = Math.max(0, selection.x - lineOffset);
        int selectionEnd = selection.y - lineOffset;
        int selectionLength = selectionEnd - selectionStart;
        int horizontalScrollOffset = this.parent.internalGetHorizontalPixel();
        int leftMargin = this.getLeftMargin();
        int lineEndSpaceWidth = this.getLineEndSpaceWidth();
        int lineHeight = this.getLineHeight();
        boolean wordWrap = this.parent.internalGetWordWrap();
        if (selectionEnd == selectionStart || selectionEnd < 0 || selectionStart > lineLength) {
            return;
        }
        int paintX = bidi != null ? this.bidiTextWidth(line, 0, selectionStart, 0, bidi) : this.textWidth(line, lineOffset, 0, selectionStart, this.filterLineStyles(styles), 0, gc, currentFont);
        if (selectionEnd > lineLength) {
            if ((this.parent.getStyle() & 0x10000) != 0) {
                selectionBackgroundWidth = Math.max(this.getClientArea().width, lineCache.getWidth());
            } else {
                selectionLength = lineLength - selectionStart;
            }
        }
        gc.setBackground(this.getSelectionBackground());
        gc.setForeground(this.getSelectionForeground());
        if (selectionBackgroundWidth == -1) {
            int lineEnd;
            int lineIndex;
            boolean isWrappedLine = false;
            if (wordWrap && (lineIndex = content.getLineAtOffset(lineEnd = lineOffset + lineLength)) < content.getLineCount() - 1 && content.getOffsetAtLine(lineIndex + 1) == lineEnd) {
                isWrappedLine = true;
            }
            if ((selectionBackgroundWidth = bidi != null ? this.bidiTextWidth(line, selectionStart, selectionLength, paintX, bidi) : this.textWidth(line, lineOffset, selectionStart, selectionLength, styles, paintX, gc, currentFont)) < 0) {
                paintX += selectionBackgroundWidth;
                selectionBackgroundWidth *= -1;
            }
            if (selectionEnd > lineLength && !isWrappedLine) {
                selectionEnd = selectionStart + selectionLength;
                if (bidi != null && selectionEnd > 0 && bidi.isRightToLeft(selectionEnd - 1)) {
                    int lineEndX = bidi.getTextWidth();
                    gc.fillRectangle(lineEndX - horizontalScrollOffset + leftMargin, paintY, lineEndSpaceWidth, lineHeight);
                } else {
                    selectionBackgroundWidth += lineEndSpaceWidth;
                }
            }
        }
        if (bidi != null && paintX == 0) {
            paintX = 3;
        }
        gc.fillRectangle(paintX - horizontalScrollOffset + leftMargin, paintY, selectionBackgroundWidth, lineHeight);
    }

    protected int[] getBidiSegments(int lineOffset, String lineText) {
        return this.parent.getBidiSegments(lineOffset, lineText);
    }

    protected Rectangle getClientArea() {
        return this.parent.getClientArea();
    }

    protected StyledTextContent getContent() {
        return this.parent.internalGetContent();
    }

    protected GC getGC() {
        return new GC(this.parent);
    }

    protected int getHorizontalPixel() {
        return this.parent.internalGetHorizontalPixel();
    }

    protected int getLastCaretDirection() {
        return this.parent.internalGetLastCaretDirection();
    }

    protected StyledTextEvent getLineBackgroundData(int lineOffset, String line) {
        return this.parent.getLineBackgroundData(lineOffset, line);
    }

    protected StyledTextEvent getLineStyleData(int lineOffset, String line) {
        StyledTextEvent logicalLineEvent = this.parent.getLineStyleData(lineOffset, line);
        if (logicalLineEvent != null) {
            logicalLineEvent = this.getLineStyleData(logicalLineEvent, lineOffset, line);
        }
        return logicalLineEvent;
    }

    protected Point getSelection() {
        return this.parent.internalGetSelection();
    }

    private Color getSelectionBackground() {
        return this.getDevice().getSystemColor(26);
    }

    private Color getSelectionForeground() {
        return this.getDevice().getSystemColor(27);
    }

    protected StyleRange[] mergeSelectionLineStyles(StyleRange[] styles) {
        Point selection = this.parent.internalGetSelection();
        int selectionStart = selection.x;
        int selectionEnd = selection.y;
        Vector<StyleRange> newStyles = new Vector<StyleRange>(styles.length);
        StyleRange selectionStyle = null;
        Color foreground = this.getSelectionForeground();
        Color background = this.getSelectionBackground();
        int i = 0;
        while (i < styles.length) {
            StyleRange style = styles[i];
            int styleEnd = style.start + style.length;
            if (styleEnd <= selectionStart) {
                newStyles.addElement(style);
            } else if (style.start < selectionStart && styleEnd > selectionStart) {
                StyleRange newStyle = (StyleRange)style.clone();
                newStyle.length -= styleEnd - selectionStart;
                newStyles.addElement(newStyle);
                selectionStyle = new StyleRange(selectionStart, styleEnd - selectionStart, foreground, background, newStyle.fontStyle);
                newStyles.addElement(selectionStyle);
                newStyle = this.setSelectionStyleEnd(selectionStyle, style);
                if (newStyle != null) {
                    newStyles.addElement(newStyle);
                }
            } else if (style.start >= selectionStart && style.start < selectionEnd) {
                int selectionStyleEnd;
                if (selectionStyle == null) {
                    selectionStyle = new StyleRange(selectionStart, style.start - selectionStart, foreground, background);
                    newStyles.addElement(selectionStyle);
                    if (style.start == selectionStart) {
                        selectionStyle.fontStyle = style.fontStyle;
                    }
                }
                if (style.start > (selectionStyleEnd = selectionStyle.start + selectionStyle.length) && selectionStyle.fontStyle != 0) {
                    selectionStyle = new StyleRange(selectionStyleEnd, style.start - selectionStyleEnd, foreground, background);
                    newStyles.addElement(selectionStyle);
                }
                if (selectionStyle.fontStyle != style.fontStyle) {
                    selectionStyle.length = style.start - selectionStyle.start;
                    selectionStyle = new StyleRange(style.start, style.length, foreground, background, style.fontStyle);
                    newStyles.addElement(selectionStyle);
                } else {
                    selectionStyle.length = styleEnd - selectionStyle.start;
                }
                StyleRange newStyle = this.setSelectionStyleEnd(selectionStyle, style);
                if (newStyle != null) {
                    newStyles.addElement(newStyle);
                }
            } else {
                if (selectionStyle == null) {
                    selectionStyle = new StyleRange(selectionStart, selectionEnd - selectionStart, foreground, background);
                    newStyles.addElement(selectionStyle);
                } else if (selectionStyle.start + selectionStyle.length < selectionEnd) {
                    if (selectionStyle.fontStyle != 0) {
                        int selectionStyleEnd = selectionStyle.start + selectionStyle.length;
                        selectionStyle = new StyleRange(selectionStyleEnd, selectionEnd - selectionStyleEnd, foreground, background);
                        newStyles.addElement(selectionStyle);
                    } else {
                        selectionStyle.length = selectionEnd - selectionStyle.start;
                    }
                }
                newStyles.addElement(style);
            }
            ++i;
        }
        if (selectionStyle == null) {
            selectionStyle = new StyleRange(selectionStart, selectionEnd - selectionStart, foreground, background);
            newStyles.addElement(selectionStyle);
        } else if (selectionStyle.start + selectionStyle.length < selectionEnd) {
            if (selectionStyle.fontStyle != 0) {
                int selectionStyleEnd = selectionStyle.start + selectionStyle.length;
                selectionStyle = new StyleRange(selectionStyleEnd, selectionEnd - selectionStyleEnd, foreground, background);
                newStyles.addElement(selectionStyle);
            } else {
                selectionStyle.length = selectionEnd - selectionStyle.start;
            }
        }
        styles = new StyleRange[newStyles.size()];
        newStyles.copyInto(styles);
        return styles;
    }

    protected boolean getWordWrap() {
        return this.parent.getWordWrap();
    }

    protected boolean isFullLineSelection() {
        return (this.parent.getStyle() & 0x10000) != 0;
    }

    private StyleRange setSelectionStyleEnd(StyleRange selectionStyle, StyleRange style) {
        int selectionEnd = this.parent.internalGetSelection().y;
        StyleRange newStyle = null;
        if (selectionStyle.start + selectionStyle.length > selectionEnd) {
            int styleEnd = style.start + style.length;
            selectionStyle.length = selectionEnd - selectionStyle.start;
            newStyle = (StyleRange)style.clone();
            newStyle.start = selectionEnd;
            newStyle.length = styleEnd - selectionEnd;
        }
        return newStyle;
    }
}

