/*
 * Decompiled with CFR 0.152.
 */
package yeoupooh.scrapper;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import yeoupooh.scrapper.DefaultLogger;
import yeoupooh.scrapper.ILogger;
import yeoupooh.scrapper.ScrapperHelper;

public class Scheduler
extends Thread {
    private String m_format = null;
    private String m_value = null;
    private boolean isActive = true;
    private ILogger m_logger = new DefaultLogger();

    public Scheduler() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("scrapper");
            this.m_format = resourceBundle.getString("scheduler.format");
            this.m_value = resourceBundle.getString("scheduler.value");
            this.m_logger = new DefaultLogger();
        }
        catch (MissingResourceException missingResourceException) {
            this.m_logger.error("resource bundle not found.");
            this.m_format = "hh:mm:ss";
            this.m_value = "08:30:00";
        }
        this.m_logger.info("format=" + this.m_format);
        this.m_logger.info("value=" + this.m_value);
    }

    public void start() {
    }

    public void run() {
        while (this.isActive) {
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(this.m_format);
            String string = simpleDateFormat.format(date);
            String string2 = simpleDateFormat2.format(date);
            if (new SimpleDateFormat("mm:ss").format(date).equals("00:00")) {
                this.m_logger.info(string + ", format=" + string2 + ", value=" + this.m_value);
            }
            if (string2.equals(this.m_value)) {
                this.isActive = false;
                this.m_logger.info("DING!!!");
                ScrapperHelper scrapperHelper = new ScrapperHelper();
                try {
                    scrapperHelper.scrapMainSite();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.isActive = true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void setLogger(ILogger iLogger) {
        this.m_logger = iLogger;
    }

    public String getFormat() {
        return this.m_format;
    }

    public String getValue() {
        return this.m_value;
    }

    public void setFormat(String string) {
        this.m_format = string;
    }

    public void setValue(String string) {
        this.m_value = string;
    }

    public static void main(String[] stringArray) {
        Thread thread = new Thread(new Scheduler());
        thread.start();
    }
}

